/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.block.custom;

import com.lumengrid.oritechthings.entity.custom.TierAddonBlockEntity;
import com.lumengrid.oritechthings.util.Constants;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.util.TooltipHelper;

public class TierAddonBlock
extends MachineAddonBlock {
    public static final EnumProperty<Constants.AddonType> ADDON_TYPE = EnumProperty.create((String)"addon_type", Constants.AddonType.class);
    public static final IntegerProperty ADDON_TIER = IntegerProperty.create((String)"tier", (int)2, (int)9);

    public TierAddonBlock(MachineAddonBlock.AddonSettings addonSettings, int tier, Constants.AddonType type) {
        super(BlockBehaviour.Properties.of().strength(2.0f).requiresCorrectToolForDrops().lightLevel(state -> (Boolean)state.getValue((Property)ADDON_USED) != false ? 10 : 0), addonSettings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)ADDON_USED, (Comparable)Boolean.valueOf(false))).setValue((Property)ADDON_TIER, (Comparable)Integer.valueOf(tier))).setValue(ADDON_TYPE, (Comparable)((Object)type)));
    }

    public IntegerProperty getAddonTier() {
        return ADDON_TIER;
    }

    public EnumProperty<Constants.AddonType> getAddonType() {
        return ADDON_TYPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        try {
            return new TierAddonBlockEntity(pos, state);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction dir = switch (ctx.getClickedFace()) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN, Direction.UP, Direction.NORTH -> Direction.NORTH;
            case Direction.SOUTH -> Direction.SOUTH;
            case Direction.WEST -> Direction.WEST;
            case Direction.EAST -> Direction.EAST;
        };
        Direction face = ctx.getClickedFace();
        AttachFace f = switch (face) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> AttachFace.CEILING;
            case Direction.UP -> AttachFace.FLOOR;
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> AttachFace.WALL;
        };
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)dir)).setValue((Property)FACE, (Comparable)f);
    }

    @NotNull
    public Class<? extends BlockEntity> getBlockEntityType() {
        return TierAddonBlockEntity.class;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.addonSettings.boundingShape()[((Direction)state.getValue((Property)FACING)).ordinal()][((AttachFace)state.getValue((Property)FACE)).ordinal()];
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ADDON_USED, FACING, FACE, ADDON_TIER, ADDON_TYPE});
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.tier_addon").withStyle(ChatFormatting.AQUA).append((Component)Component.literal((String)((Integer)this.defaultBlockState().getValue((Property)ADDON_TIER)).toString()).withStyle(ChatFormatting.AQUA)));
        if (Screen.hasControlDown()) {
            int displayedNumber;
            if (this.addonSettings.speedMultiplier() != 1.0f) {
                displayedNumber = Math.round((1.0f - this.addonSettings.speedMultiplier()) * 100.0f);
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_speed_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedValueChangeTooltip((int)displayedNumber)));
            }
            if (this.addonSettings.efficiencyMultiplier() != 1.0f) {
                displayedNumber = Math.round((1.0f - this.addonSettings.efficiencyMultiplier()) * 100.0f);
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_efficiency_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedValueChangeTooltip((int)displayedNumber)));
            }
            if (this.addonSettings.addedCapacity() != 0L) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_capacity_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedEnergyChangeTooltip((long)this.addonSettings.addedCapacity(), (String)" RF")));
            }
            if (this.addonSettings.addedInsert() != 0L) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritech.addon_transfer_desc").withStyle(ChatFormatting.DARK_GRAY).append(TooltipHelper.getFormattedEnergyChangeTooltip((long)this.addonSettings.addedInsert(), (String)" RF/t")));
            }
            if (this.addonSettings.chamberCount() > 1) {
                tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.tiered_addons.chambers_desc").withStyle(ChatFormatting.DARK_GRAY).append((Component)Component.literal((String)("+" + (this.addonSettings.chamberCount() - 1))).withStyle(ChatFormatting.GREEN)));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }
}

