/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.client.screen;

import com.lumengrid.oritechthings.client.screen.component.CustomButton;
import com.lumengrid.oritechthings.client.screen.component.Slider;
import com.lumengrid.oritechthings.network.packet.FramePlacerPacket;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FramePlacerScreen
extends Screen {
    private final BlockPos startPos;
    private final Direction facing;
    private Slider xSlider;
    private Slider ySlider;
    private Slider offsetSlider;
    private CustomButton abortButton;
    private CustomButton confirmButton;
    private CustomButton xDecrementButton;
    private CustomButton xIncrementButton;
    private CustomButton yDecrementButton;
    private CustomButton yIncrementButton;
    private CustomButton offsetDecrementButton;
    private CustomButton offsetIncrementButton;
    private int xValue = 5;
    private int yValue = 5;
    private int offsetValue = 2;
    private int frameCountRequired;

    public FramePlacerScreen(BlockPos pos, Direction facing) {
        super((Component)Component.translatable((String)"item.oritechthings.frame_placer"));
        this.startPos = pos;
        this.facing = facing;
    }

    protected void init() {
        int widthSlider = 124;
        this.xSlider = new Slider(this.width / 2 - widthSlider / 2, this.height / 2 - 40, widthSlider, 14, 3.0, 64.0, (Component)Component.literal((String)"X "), this.xValue, slider -> {
            this.xValue = slider.getValueInt();
            this.updateOffsetSlider();
            this.updateFrameCount();
        });
        this.xDecrementButton = new CustomButton(this.xSlider.getX() - 20, this.xSlider.getY(), 20, 14, (Component)Component.literal((String)"-"), button -> this.decrementX(), Color.GRAY.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.xIncrementButton = new CustomButton(this.xSlider.getX() + widthSlider + 2, this.xSlider.getY(), 20, 14, (Component)Component.literal((String)"+"), button -> this.incrementX(), Color.GRAY.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.ySlider = new Slider(this.width / 2 - widthSlider / 2, this.height / 2 - 20, widthSlider, 14, 3.0, 64.0, (Component)Component.literal((String)"Y "), this.yValue, slider -> {
            this.yValue = slider.getValueInt();
            this.updateFrameCount();
        });
        this.yDecrementButton = new CustomButton(this.ySlider.getX() - 20, this.ySlider.getY(), 20, 14, (Component)Component.literal((String)"-"), button -> this.decrementY(), Color.GRAY.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.yIncrementButton = new CustomButton(this.ySlider.getX() + widthSlider + 2, this.ySlider.getY(), 20, 14, (Component)Component.literal((String)"+"), button -> this.incrementY(), Color.GRAY.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.offsetSlider = new Slider(this.width / 2 - widthSlider / 2, this.height / 2, widthSlider, 14, 1.0, 63.0, (Component)Component.literal((String)"Offset "), this.offsetValue, slider -> {
            this.offsetValue = slider.getValueInt();
        });
        this.offsetDecrementButton = new CustomButton(this.offsetSlider.getX() - 20, this.offsetSlider.getY(), 20, 14, (Component)Component.literal((String)"-"), button -> this.decrementOffset(), Color.GRAY.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.offsetIncrementButton = new CustomButton(this.offsetSlider.getX() + widthSlider + 2, this.offsetSlider.getY(), 20, 14, (Component)Component.literal((String)"+"), button -> this.incrementOffset(), Color.GRAY.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.abortButton = new CustomButton(this.width / 2 - 60, this.height / 2 + 40, 50, 20, (Component)Component.literal((String)"Abort"), button -> this.abort(), Color.RED.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.confirmButton = new CustomButton(this.width / 2 + 10, this.height / 2 + 40, 50, 20, (Component)Component.literal((String)"Confirm"), button -> this.confirmDimensions(), Color.GREEN.getRGB(), Color.WHITE.getRGB(), Color.BLACK.getRGB());
        this.updateFrameCount();
        this.addWidget((GuiEventListener)this.xSlider);
        this.addWidget((GuiEventListener)this.ySlider);
        this.addWidget((GuiEventListener)this.offsetSlider);
        this.addWidget((GuiEventListener)this.xDecrementButton);
        this.addWidget((GuiEventListener)this.xIncrementButton);
        this.addWidget((GuiEventListener)this.yDecrementButton);
        this.addWidget((GuiEventListener)this.yIncrementButton);
        this.addWidget((GuiEventListener)this.offsetDecrementButton);
        this.addWidget((GuiEventListener)this.offsetIncrementButton);
        this.addWidget((GuiEventListener)this.abortButton);
        this.addWidget((GuiEventListener)this.confirmButton);
    }

    private void updateOffsetSlider() {
        int maxOffset = this.xValue - 1;
        this.offsetSlider.setMax(maxOffset);
        if (this.offsetValue > maxOffset) {
            this.offsetValue = maxOffset;
        }
    }

    private void decrementX() {
        if (this.xValue > 3) {
            --this.xValue;
            this.xSlider.setValue(this.xValue);
            this.updateOffsetSlider();
        }
    }

    private void incrementX() {
        if (this.xValue < 64) {
            ++this.xValue;
            this.xSlider.setValue(this.xValue);
            this.updateOffsetSlider();
        }
    }

    private void decrementY() {
        if (this.yValue > 3) {
            --this.yValue;
            this.ySlider.setValue(this.yValue);
        }
    }

    private void incrementY() {
        if (this.yValue < 64) {
            ++this.yValue;
            this.ySlider.setValue(this.yValue);
        }
    }

    private void decrementOffset() {
        if (this.offsetValue > 1) {
            --this.offsetValue;
            this.offsetSlider.setValue(this.offsetValue);
        }
    }

    private void incrementOffset() {
        int maxOffset = this.xValue - 1;
        this.offsetSlider.setMax(maxOffset);
        if (this.offsetValue < maxOffset) {
            ++this.offsetValue;
            this.offsetSlider.setValue(this.offsetValue);
        }
    }

    private void updateFrameCount() {
        this.frameCountRequired = 2 * (this.xValue + this.yValue) - 4;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        super.render(guiGraphics, mx, my, partialTicks);
        guiGraphics.drawCenteredString(this.font, "Set Dimensions for the Frame", this.width / 2, this.height / 2 - 60, Color.GREEN.getRGB());
        this.xSlider.render(guiGraphics, mx, my, partialTicks);
        this.ySlider.render(guiGraphics, mx, my, partialTicks);
        this.offsetSlider.render(guiGraphics, mx, my, partialTicks);
        this.xDecrementButton.render(guiGraphics, mx, my, partialTicks);
        this.xIncrementButton.render(guiGraphics, mx, my, partialTicks);
        this.yDecrementButton.render(guiGraphics, mx, my, partialTicks);
        this.yIncrementButton.render(guiGraphics, mx, my, partialTicks);
        this.offsetDecrementButton.render(guiGraphics, mx, my, partialTicks);
        this.offsetIncrementButton.render(guiGraphics, mx, my, partialTicks);
        this.abortButton.render(guiGraphics, mx, my, partialTicks);
        this.confirmButton.render(guiGraphics, mx, my, partialTicks);
        guiGraphics.drawCenteredString(this.font, "Frame Blocks Required: " + this.frameCountRequired, this.width / 2, this.height / 2 - 80, Color.WHITE.getRGB());
    }

    private void abort() {
        Minecraft.getInstance().setScreen(null);
    }

    private void confirmDimensions() {
        PacketDistributor.sendToServer((CustomPacketPayload)new FramePlacerPacket(this.startPos, this.xValue, this.yValue, this.offsetValue, this.facing), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().setScreen(null);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

