/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.event;

import com.lumengrid.oritechthings.main.ModDataComponents;
import com.lumengrid.oritechthings.util.RenderBlockUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import rearth.oritech.init.ComponentContent;
import rearth.oritech.item.tools.LaserTargetDesignator;

public class RenderWorldLastEvent {
    @SubscribeEvent
    static void renderWorldLastEvent(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        RenderWorldLastEvent.checkTargetDesignator((Player)player, InteractionHand.MAIN_HAND);
        RenderWorldLastEvent.checkTargetDesignator((Player)player, InteractionHand.OFF_HAND);
    }

    private static void checkTargetDesignator(Player player, InteractionHand hand) {
        ResourceKey dimension;
        ItemStack item = player.getItemInHand(hand);
        if (item.isEmpty() || !(item.getItem() instanceof LaserTargetDesignator)) {
            return;
        }
        BlockPos targetPos = (BlockPos)item.get((DataComponentType)ComponentContent.TARGET_POSITION.get());
        if (targetPos != null && ((dimension = (ResourceKey)item.get((DataComponentType)ModDataComponents.TARGET_DIMENSION.get())) == null || dimension == player.level().dimension())) {
            RenderBlockUtils.createBox(targetPos);
        }
    }
}

