/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.fml.loading.FMLPaths;

public class ConfigLoader {
    public static final String CONFIG_FILE = "oritech-things.json5";
    private static ConfigLoader INSTANCE = new ConfigLoader();
    @Expose
    public List<AddonInfo> addonSettings = new ArrayList<AddonInfo>(List.of(new AddonInfo(0.79f, 1.1f, 0.86f, 4000000L, 2000L, 1000000L, 4000L, 2.0f, 2), new AddonInfo(0.7f, 1.15f, 0.81f, 6000000L, 3000L, 1500000L, 6000L, 2.5f, 3), new AddonInfo(0.6f, 1.22f, 0.725f, 8000000L, 4000L, 2000000L, 8000L, 3.0f, 4), new AddonInfo(0.5f, 1.36f, 0.62f, 10000000L, 5000L, 2500000L, 10000L, 3.5f, 5), new AddonInfo(0.4f, 1.6f, 0.47f, 12000000L, 6000L, 3000000L, 12000L, 4.0f, 6), new AddonInfo(0.3f, 2.1f, 0.3f, 14000000L, 7000L, 3500000L, 14000L, 4.5f, 7), new AddonInfo(0.2f, 3.3f, 0.153f, 16000000L, 8000L, 4000000L, 14000L, 5.0f, 8), new AddonInfo(0.1f, 6.3f, 0.1f, 18000000L, 9000L, 4500000L, 18000L, 5.5f, 9)));
    @Expose
    public ExoJetPack exoJetPackSettings = new ExoJetPack(true, 10000L);

    private ConfigLoader() {
    }

    public static ConfigLoader getInstance() {
        return INSTANCE != null ? INSTANCE : new ConfigLoader();
    }

    public void load() {
        block9: {
            Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().setPrettyPrinting().create();
            Path configPath = FMLPaths.CONFIGDIR.get().resolve(CONFIG_FILE);
            File file = configPath.toFile();
            try {
                if (!file.exists()) {
                    System.out.println("Configuration file does not exist. Creating a new one.");
                    this.saveDefaultConfig(file, gson);
                    break block9;
                }
                try (JsonReader jsonReader = new JsonReader((Reader)new FileReader(file));){
                    INSTANCE = (ConfigLoader)gson.fromJson(jsonReader, ConfigLoader.class);
                    if (INSTANCE == null) {
                        throw new JsonSyntaxException("Parsed configuration is null.");
                    }
                }
            }
            catch (JsonSyntaxException | IOException e) {
                System.err.println("Invalid configuration file. Regenerating default config.");
                this.saveDefaultConfig(file, gson);
            }
        }
    }

    private void saveDefaultConfig(File file, Gson gson) {
        try (FileWriter writer = new FileWriter(file);){
            if (INSTANCE == null) {
                INSTANCE = new ConfigLoader();
            }
            gson.toJson((Object)INSTANCE, ConfigLoader.class, (Appendable)writer);
            System.out.println("Default configuration file created successfully.");
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create default configuration file.", e);
        }
    }

    public record AddonInfo(@Expose float speedMultiplier, @Expose float efficiencyDown, @Expose float efficiencyUp, @Expose long capacitorCapacity, @Expose long capacitorRate, @Expose long acceptorCapacity, @Expose long acceptorRate, @Expose float processingEfficiency, @Expose int processingChambers) {
    }

    public record ExoJetPack(@Expose boolean enabledCreativeFlight, @Expose long rfThreshold) {
    }
}

