/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.network.packet;

import com.lumengrid.oritechthings.entity.custom.AcceleratorSpeedSensorBlockEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record UpdateSpeedSensorC2SPacket(BlockPos pos, int speed, boolean active, boolean checkGreater) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateSpeedSensorC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"oritechthings", (String)"update_speed_sensor"));
    public static final StreamCodec<ByteBuf, UpdateSpeedSensorC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, UpdateSpeedSensorC2SPacket::pos, (StreamCodec)ByteBufCodecs.INT, UpdateSpeedSensorC2SPacket::speed, (StreamCodec)ByteBufCodecs.BOOL, UpdateSpeedSensorC2SPacket::active, (StreamCodec)ByteBufCodecs.BOOL, UpdateSpeedSensorC2SPacket::checkGreater, UpdateSpeedSensorC2SPacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleDataOnServer(UpdateSpeedSensorC2SPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        ServerLevel serverLevel = sPlayer.serverLevel();
        BlockEntity e = serverLevel.getBlockEntity(packet.pos());
        if (!(e instanceof AcceleratorSpeedSensorBlockEntity)) {
            return;
        }
        AcceleratorSpeedSensorBlockEntity be = (AcceleratorSpeedSensorBlockEntity)e;
        be.setSpeedLimit(packet.speed());
        be.setEnabled(packet.active());
        be.setCheckGreater(packet.checkGreater());
    }
}

