/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.item.custom;

import com.lumengrid.oritechthings.client.screen.FramePlacerScreen;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.base.block.MultiblockMachine;
import rearth.oritech.block.base.entity.FrameInteractionBlockEntity;
import rearth.oritech.util.Geometry;

public class FramePlacer
extends Item {
    public FramePlacer(Item.Properties settings) {
        super(settings);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockEntity targetEntity = level.getBlockEntity(pos);
        if (!(targetEntity instanceof FrameInteractionBlockEntity)) {
            Objects.requireNonNull(context.getPlayer()).sendSystemMessage((Component)Component.translatable((String)"message.oritechthings.frame_placer.wrong_machine").withStyle(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        FrameInteractionBlockEntity entity = (FrameInteractionBlockEntity)targetEntity;
        BlockState targetState = level.getBlockState(pos);
        if (!((Boolean)targetState.getValue((Property)MultiblockMachine.ASSEMBLED)).booleanValue()) {
            Objects.requireNonNull(context.getPlayer()).sendSystemMessage((Component)Component.translatable((String)"message.oritechthings.frame_placer.not_assembled").withStyle(ChatFormatting.RED));
            return InteractionResult.FAIL;
        }
        Vec3i backRelative = new Vec3i(entity.getFrameOffset(), 0, 0);
        Direction facing = (Direction)targetState.getValue((Property)HorizontalDirectionalBlock.FACING);
        BlockPos searchStart = (BlockPos)Geometry.offsetToWorldPosition((Direction)facing, (Vec3i)backRelative, (Vec3i)pos);
        Minecraft mc = Minecraft.getInstance();
        mc.execute(() -> mc.setScreen((Screen)new FramePlacerScreen(searchStart, facing.getOpposite())));
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, List<Component> tooltip, @NotNull TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.frame_placer").withStyle(ChatFormatting.ITALIC));
    }
}

