/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.block;

import com.lumengrid.oritechthings.block.custom.AcceleratorSpeedSensorBlock;
import com.lumengrid.oritechthings.block.custom.InfestedAmethystBlock;
import com.lumengrid.oritechthings.block.custom.TierAddonBlock;
import com.lumengrid.oritechthings.item.ModItems;
import com.lumengrid.oritechthings.main.ConfigLoader;
import com.lumengrid.oritechthings.util.Constants;
import com.lumengrid.oritechthings.util.ShapeUtil;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.util.Geometry;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"oritechthings");
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_2 = ModBlocks.speedAddonBuilder(2);
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_3 = ModBlocks.speedAddonBuilder(3);
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_4 = ModBlocks.speedAddonBuilder(4);
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_5 = ModBlocks.speedAddonBuilder(5);
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_6 = ModBlocks.speedAddonBuilder(6);
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_7 = ModBlocks.speedAddonBuilder(7);
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_8 = ModBlocks.speedAddonBuilder(8);
    public static final DeferredBlock<Block> ADDON_BLOCK_SPEED_TIER_9 = ModBlocks.speedAddonBuilder(9);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_2 = ModBlocks.efficientSpeedAddonBuilder(2);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_3 = ModBlocks.efficientSpeedAddonBuilder(3);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_4 = ModBlocks.efficientSpeedAddonBuilder(4);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_5 = ModBlocks.efficientSpeedAddonBuilder(5);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_6 = ModBlocks.efficientSpeedAddonBuilder(6);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_7 = ModBlocks.efficientSpeedAddonBuilder(7);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_8 = ModBlocks.efficientSpeedAddonBuilder(8);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENT_SPEED_TIER_9 = ModBlocks.efficientSpeedAddonBuilder(9);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_2 = ModBlocks.efficiencyAddonBuilder(2);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_3 = ModBlocks.efficiencyAddonBuilder(3);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_4 = ModBlocks.efficiencyAddonBuilder(4);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_5 = ModBlocks.efficiencyAddonBuilder(5);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_6 = ModBlocks.efficiencyAddonBuilder(6);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_7 = ModBlocks.efficiencyAddonBuilder(7);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_8 = ModBlocks.efficiencyAddonBuilder(8);
    public static final DeferredBlock<Block> ADDON_BLOCK_EFFICIENCY_TIER_9 = ModBlocks.efficiencyAddonBuilder(9);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_2 = ModBlocks.capacitorAddonBuilder(2);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_3 = ModBlocks.capacitorAddonBuilder(3);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_4 = ModBlocks.capacitorAddonBuilder(4);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_5 = ModBlocks.capacitorAddonBuilder(5);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_6 = ModBlocks.capacitorAddonBuilder(6);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_7 = ModBlocks.capacitorAddonBuilder(7);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_8 = ModBlocks.capacitorAddonBuilder(8);
    public static final DeferredBlock<Block> ADDON_BLOCK_CAPACITOR_TIER_9 = ModBlocks.capacitorAddonBuilder(9);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_2 = ModBlocks.acceptorAddonBuilder(2);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_3 = ModBlocks.acceptorAddonBuilder(3);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_4 = ModBlocks.acceptorAddonBuilder(4);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_5 = ModBlocks.acceptorAddonBuilder(5);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_6 = ModBlocks.acceptorAddonBuilder(6);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_7 = ModBlocks.acceptorAddonBuilder(7);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_8 = ModBlocks.acceptorAddonBuilder(8);
    public static final DeferredBlock<Block> ADDON_BLOCK_ACCEPTOR_TIER_9 = ModBlocks.acceptorAddonBuilder(9);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_2 = ModBlocks.processingAddonBuilder(2);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_3 = ModBlocks.processingAddonBuilder(3);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_4 = ModBlocks.processingAddonBuilder(4);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_5 = ModBlocks.processingAddonBuilder(5);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_6 = ModBlocks.processingAddonBuilder(6);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_7 = ModBlocks.processingAddonBuilder(7);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_8 = ModBlocks.processingAddonBuilder(8);
    public static final DeferredBlock<Block> ADDON_BLOCK_PROCESSING_TIER_9 = ModBlocks.processingAddonBuilder(9);
    public static final DeferredBlock<Block> ACCELERATOR_SPEED_SENSOR = ModBlocks.registerBlock("accelerator_speed_sensor", AcceleratorSpeedSensorBlock::new);
    public static final DeferredBlock<Block> INFESTED_AMETHYST_BLOCK = ModBlocks.registerBlock("infested_amethyst_block", () -> new InfestedAmethystBlock(Blocks.AMETHYST_BLOCK, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PURPLE).strength(1.5f).sound(SoundType.AMETHYST)));

    private static DeferredBlock<Block> processingAddonBuilder(int tier) {
        return ModBlocks.registerBlock(Constants.NameUtil.genAddonName(Constants.NameUtil.Type.PROCESSING, tier), () -> new TierAddonBlock(MachineAddonBlock.AddonSettings.getDefaultSettings().withEfficiencyMultiplier(ConfigLoader.getInstance().addonSettings.get(tier - 2).processingEfficiency()).withChambers(ConfigLoader.getInstance().addonSettings.get(tier - 2).processingChambers()).withNeedsSupport(true).withBoundingShape(ModBlocks.generateAddonShape(7)), tier, Constants.AddonType.PROCESSING));
    }

    private static DeferredBlock<Block> capacitorAddonBuilder(int tier) {
        return ModBlocks.registerBlock(Constants.NameUtil.genAddonName(Constants.NameUtil.Type.CAPACITOR, tier), () -> new TierAddonBlock(MachineAddonBlock.AddonSettings.getDefaultSettings().withAddedCapacity(ConfigLoader.getInstance().addonSettings.get(tier - 2).capacitorCapacity()).withAddedInsert(ConfigLoader.getInstance().addonSettings.get(tier - 2).capacitorRate()).withNeedsSupport(true).withBoundingShape(ModBlocks.generateAddonShape(6)), tier, Constants.AddonType.CAPACITOR));
    }

    private static DeferredBlock<Block> acceptorAddonBuilder(int tier) {
        return ModBlocks.registerBlock(Constants.NameUtil.genAddonName(Constants.NameUtil.Type.ACCEPTOR, tier), () -> new TierAddonBlock(MachineAddonBlock.AddonSettings.getDefaultSettings().withAddedCapacity(ConfigLoader.getInstance().addonSettings.get(tier - 2).acceptorCapacity()).withAddedInsert(ConfigLoader.getInstance().addonSettings.get(tier - 2).acceptorRate()).withAcceptEnergy(true).withNeedsSupport(true).withBoundingShape(ModBlocks.generateAddonShape(8)), tier, Constants.AddonType.ACCEPTOR));
    }

    private static DeferredBlock<Block> efficientSpeedAddonBuilder(int tier) {
        return ModBlocks.registerBlock(Constants.NameUtil.genAddonName(Constants.NameUtil.Type.EFFICIENT + Constants.NameUtil.Type.SPEED, tier), () -> new TierAddonBlock(MachineAddonBlock.AddonSettings.getDefaultSettings().withSpeedMultiplier(ConfigLoader.getInstance().addonSettings.get(tier - 2).speedMultiplier()).withEfficiencyMultiplier(ConfigLoader.getInstance().addonSettings.get(tier - 2).efficiencyUp()).withNeedsSupport(true).withBoundingShape(ModBlocks.generateAddonShape(2)), tier, Constants.AddonType.EFFICIENT_SPEED));
    }

    private static DeferredBlock<Block> speedAddonBuilder(int tier) {
        return ModBlocks.registerBlock(Constants.NameUtil.genAddonName(Constants.NameUtil.Type.SPEED, tier), () -> new TierAddonBlock(MachineAddonBlock.AddonSettings.getDefaultSettings().withSpeedMultiplier(ConfigLoader.getInstance().addonSettings.get(tier - 2).speedMultiplier()).withEfficiencyMultiplier(ConfigLoader.getInstance().addonSettings.get(tier - 2).efficiencyDown()).withNeedsSupport(true).withBoundingShape(ModBlocks.generateAddonShape(2)), tier, Constants.AddonType.SPEED));
    }

    private static DeferredBlock<Block> efficiencyAddonBuilder(int tier) {
        return ModBlocks.registerBlock(Constants.NameUtil.genAddonName(Constants.NameUtil.Type.EFFICIENCY, tier), () -> new TierAddonBlock(MachineAddonBlock.AddonSettings.getDefaultSettings().withEfficiencyMultiplier(ConfigLoader.getInstance().addonSettings.get(tier - 2).efficiencyUp()).withNeedsSupport(true).withBoundingShape(ModBlocks.generateAddonShape(5)), tier, Constants.AddonType.EFFICIENCY));
    }

    private static VoxelShape[][] generateAddonShape(int y) {
        VoxelShape[][] shape = new VoxelShape[Direction.values().length][AttachFace.values().length];
        for (Direction facing : Direction.values()) {
            AttachFace[] faces;
            if (!facing.getAxis().isHorizontal()) continue;
            for (AttachFace face : faces = AttachFace.values()) {
                shape[facing.ordinal()][face.ordinal()] = Shapes.or((VoxelShape)Geometry.rotateVoxelShape((VoxelShape)ShapeUtil.shapeFromDimension(1.0f, 0.0f, 1.0f, 14.0f, y, 14.0f), (Direction)facing, (AttachFace)face), (VoxelShape)Geometry.rotateVoxelShape((VoxelShape)ShapeUtil.shapeFromDimension(3.0f, 2.0f, 3.0f, 10.0f, y, 10.0f), (Direction)facing, (AttachFace)face));
            }
        }
        return shape;
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

