/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.entity.custom;

import com.lumengrid.oritechthings.block.custom.AcceleratorSpeedSensorBlock;
import com.lumengrid.oritechthings.entity.ModEntities;
import com.lumengrid.oritechthings.menu.AcceleratorSpeedSensorMenu;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;

public class AcceleratorSpeedSensorBlockEntity
extends BlockEntity
implements MenuProvider {
    private int speedLimit = 1000;
    private boolean enabled = false;
    private boolean checkGreater = true;
    @Nullable
    private BlockPos targetDesignator;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            AcceleratorSpeedSensorBlockEntity.this.sync();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return true;
        }
    };

    public AcceleratorSpeedSensorBlockEntity(BlockPos pos, BlockState state) {
        super(ModEntities.accelerator_speed_sensor.get(), pos, state);
    }

    public int getSpeedLimit() {
        return this.speedLimit;
    }

    public void setSpeedLimit(int speed) {
        this.speedLimit = speed;
    }

    public boolean isCheckGreater() {
        return this.checkGreater;
    }

    public void setCheckGreater(boolean checkGreater) {
        this.checkGreater = checkGreater;
        this.sync();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.sync();
    }

    public void sync() {
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public BlockPos getTargetDesignator() {
        return this.targetDesignator;
    }

    public boolean setTargetDesignator(@Nullable BlockPos targetPos, Player player) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = blockEntity = targetPos == null ? null : Objects.requireNonNull(this.level).getBlockEntity(targetPos);
        if (targetPos == null || !(blockEntity instanceof AcceleratorControllerBlockEntity)) {
            player.sendSystemMessage((Component)Component.translatable((String)"block.oritechthings.accelerator_speed_sensor.invalid_controller").withStyle(ChatFormatting.RED));
            return false;
        }
        int distance = targetPos.distManhattan((Vec3i)this.getBlockPos());
        if (distance > 128) {
            player.sendSystemMessage((Component)Component.translatable((String)"block.oritechthings.accelerator_speed_sensor.invalid_controller.to_far").append((Component)Component.literal((String)(" (" + distance + ")")).withStyle(ChatFormatting.ITALIC)).withStyle(ChatFormatting.RED));
            return false;
        }
        this.targetDesignator = targetPos;
        this.setEnabled(true);
        this.level.playSound(player, this.getBlockPos(), SoundEvents.ALLAY_AMBIENT_WITH_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
        player.sendSystemMessage((Component)Component.translatable((String)"block.oritechthings.accelerator_speed_sensor.controller_set").append((Component)Component.literal((String)targetPos.toShortString()).withStyle(ChatFormatting.BLUE)));
        this.sync();
        return true;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, registries);
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryLookup) {
        super.saveAdditional(tag, registryLookup);
        tag.putInt("SpeedLimit", this.speedLimit);
        tag.putBoolean("Enabled", this.enabled);
        tag.putBoolean("CheckGreater", this.checkGreater);
        if (this.targetDesignator != null) {
            tag.putLong("TargetDesignator", this.targetDesignator.asLong());
        }
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registryLookup));
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryLookup) {
        super.loadAdditional(tag, registryLookup);
        this.speedLimit = tag.getInt("SpeedLimit");
        this.enabled = tag.getBoolean("Enabled");
        this.checkGreater = tag.getBoolean("CheckGreater");
        if (tag.contains("TargetDesignator")) {
            this.targetDesignator = BlockPos.of((long)tag.getLong("TargetDesignator"));
        }
        this.inventory.deserializeNBT(registryLookup, tag.getCompound("Inventory"));
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T ignoredT) {
        if (level.isClientSide) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AcceleratorSpeedSensorBlockEntity)) {
            return;
        }
        AcceleratorSpeedSensorBlockEntity speedControl = (AcceleratorSpeedSensorBlockEntity)blockEntity;
        if (!speedControl.isEnabled() || speedControl.getTargetDesignator() == null) {
            AcceleratorSpeedSensorBlockEntity.setPowered(level, pos, state, false);
            return;
        }
        BlockEntity entity = level.getBlockEntity(speedControl.getTargetDesignator());
        boolean powered = AcceleratorSpeedSensorBlockEntity.isPowered(speedControl, entity);
        if (powered != (Boolean)state.getValue((Property)AcceleratorSpeedSensorBlock.POWERED)) {
            AcceleratorSpeedSensorBlockEntity.setPowered(level, pos, state, powered);
        }
    }

    private static void setPowered(Level level, BlockPos pos, BlockState state, boolean powered) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AcceleratorSpeedSensorBlock.POWERED, (Comparable)Boolean.valueOf(powered)), 3);
        AcceleratorSpeedSensorBlockEntity.notifyNeighbors(level, pos);
    }

    private static boolean isPowered(AcceleratorSpeedSensorBlockEntity speedControl, BlockEntity entity) {
        AcceleratorControllerBlockEntity accelerator;
        AcceleratorParticleLogic.ActiveParticle part;
        boolean powered = false;
        if (entity instanceof AcceleratorControllerBlockEntity && (part = (accelerator = (AcceleratorControllerBlockEntity)entity).getParticle()) != null) {
            if (speedControl.isCheckGreater() && part.velocity > (float)speedControl.speedLimit) {
                powered = true;
            } else if (!speedControl.isCheckGreater() && part.velocity < (float)speedControl.speedLimit) {
                powered = true;
            }
        }
        return powered;
    }

    private static void notifyNeighbors(Level level, BlockPos pos) {
        level.updateNeighborsAt(pos, level.getBlockState(pos).getBlock());
        for (Direction direction : Direction.values()) {
            level.updateNeighborsAt(pos.relative(direction), level.getBlockState(pos).getBlock());
        }
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.oritechthings.accelerator_speed_sensor");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, @NotNull Inventory inventory, @NotNull Player player) {
        return new AcceleratorSpeedSensorMenu(i, inventory, this);
    }
}

