/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.event;

import com.lumengrid.oritechthings.main.ConfigLoader;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import rearth.oritech.init.ToolsContent;
import rearth.oritech.item.tools.util.OritechEnergyItem;

@EventBusSubscriber(modid="oritechthings", bus=EventBusSubscriber.Bus.GAME)
public class GameBusEvents {
    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (!event.getEntity().level().isClientSide) {
            Player player = event.getEntity();
            if (player.isCreative() || player.isSpectator()) {
                return;
            }
            if (!ConfigLoader.getInstance().exoJetPackSettings.enabledCreativeFlight()) {
                return;
            }
            ItemStack armor = (ItemStack)player.getInventory().armor.get(2);
            if (armor.getItem() == ToolsContent.EXO_JETPACK.asItem()) {
                long energy = 0L;
                Item item = armor.getItem();
                if (item instanceof OritechEnergyItem) {
                    OritechEnergyItem energyItem = (OritechEnergyItem)item;
                    energy = energyItem.getStoredEnergy(armor);
                }
                if (energy <= ConfigLoader.getInstance().exoJetPackSettings.rfThreshold()) {
                    if (player.getAbilities().mayfly) {
                        player.displayClientMessage((Component)Component.translatable((String)"message.exojetpack.energy_low"), true);
                    }
                    GameBusEvents.setCreativeFlight(player, false);
                    return;
                }
                if (!player.getAbilities().mayfly) {
                    GameBusEvents.setCreativeFlight(player, true);
                }
            } else if (player.getAbilities().mayfly) {
                GameBusEvents.setCreativeFlight(player, false);
            }
        }
    }

    private static void setCreativeFlight(Player player, Boolean bool) {
        if (!bool.booleanValue()) {
            player.getAbilities().flying = bool;
        }
        player.getAbilities().mayfly = bool;
        player.onUpdateAbilities();
    }
}

