/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.block.custom;

import com.lumengrid.oritechthings.entity.custom.AcceleratorSpeedSensorBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class AcceleratorSpeedSensorBlock
extends BaseEntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public AcceleratorSpeedSensorBlock() {
        super(BlockBehaviour.Properties.of().strength(2.0f).requiresCorrectToolForDrops().lightLevel(state -> (Boolean)state.getValue((Property)POWERED) != false ? 1 : 0).isRedstoneConductor((state, blockGetter, pos) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public AcceleratorSpeedSensorBlock(BlockBehaviour.Properties p) {
        this();
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof AcceleratorSpeedSensorBlockEntity)) {
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        player.openMenu(state.getMenuProvider(level, pos), p -> p.writeBlockPos(pos));
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AcceleratorSpeedSensorBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return AcceleratorSpeedSensorBlockEntity::tick;
    }

    public int getSignal(@NotNull BlockState blockState, @NotNull BlockGetter blockAccess, @NotNull BlockPos pos, @NotNull Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public int getDirectSignal(@NotNull BlockState blockState, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return true;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return AcceleratorSpeedSensorBlock.simpleCodec(AcceleratorSpeedSensorBlock::new);
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag options) {
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.particle_accelerator_speed_sensor").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.empty());
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.particle_accelerator_speed_sensor.target_designator_usage").withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.particle_accelerator_speed_sensor.target_designator_step1").withStyle(ChatFormatting.BLUE));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.particle_accelerator_speed_sensor.target_designator_step2").withStyle(ChatFormatting.BLUE));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.particle_accelerator_speed_sensor.target_designator_step3").withStyle(ChatFormatting.BLUE));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.particle_accelerator_speed_sensor.target_designator_benefit").withStyle(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        }
        super.appendHoverText(stack, context, tooltip, options);
    }
}

