/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.mixin;

import com.lumengrid.oritechthings.api.MagneticFieldController;
import com.lumengrid.oritechthings.entity.custom.AcceleratorMagneticFieldBlockEntity;
import com.lumengrid.oritechthings.main.ConfigLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rearth.oritech.block.entity.accelerator.AcceleratorControllerBlockEntity;
import rearth.oritech.block.entity.accelerator.AcceleratorParticleLogic;

@Mixin(value={AcceleratorParticleLogic.class})
public class AcceleratorParticleLogicMixin {
    @Shadow
    @Final
    private AcceleratorControllerBlockEntity entity;
    @Shadow
    @Final
    private ServerLevel world;
    private static final ThreadLocal<AcceleratorControllerBlockEntity> currentAccelerator = new ThreadLocal();
    private static final Map<BlockPos, Long> lastTickLogged = new HashMap<BlockPos, Long>();
    private static final Map<BlockPos, Integer> callsThisTick = new HashMap<BlockPos, Integer>();
    private static final Map<BlockPos, Long> lastEnergyTick = new HashMap<BlockPos, Long>();

    @Inject(method={"getRequiredBendDist"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getRequiredBendDistWithMagneticField(float speed, CallbackInfoReturnable<Float> cir) {
        float combinedDist;
        float originalRequiredDist = ((Float)cir.getReturnValue()).floatValue();
        AcceleratorControllerBlockEntity currentEntity = currentAccelerator.get();
        if (currentEntity != null && currentEntity.getParticle() != null && (combinedDist = currentEntity.getParticle().lastBendDistance + currentEntity.getParticle().lastBendDistance2) <= originalRequiredDist && AcceleratorParticleLogicMixin.canMagneticFieldAssistStatic(originalRequiredDist - combinedDist, speed)) {
            cir.setReturnValue((Object)Float.valueOf(Float.MIN_VALUE));
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(originalRequiredDist));
    }

    private static boolean canMagneticFieldAssistStatic(float requiredDist, float speed) {
        ConfigLoader.MagneticField config = ConfigLoader.getInstance().magneticFieldSettings;
        if (!config.enabled()) {
            return false;
        }
        AcceleratorControllerBlockEntity currentEntity = currentAccelerator.get();
        if (currentEntity == null) {
            return false;
        }
        if (!(currentEntity instanceof MagneticFieldController)) {
            return false;
        }
        List<BlockPos> linkedMagnets = ((MagneticFieldController)currentEntity).getLinkedMagneticFields();
        if (linkedMagnets.isEmpty()) {
            return false;
        }
        Level world = currentEntity.getLevel();
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        BlockEntity blockEntity = serverWorld.getBlockEntity(linkedMagnets.getFirst());
        if (blockEntity instanceof AcceleratorMagneticFieldBlockEntity) {
            boolean alreadyConsumedThisTick;
            AcceleratorMagneticFieldBlockEntity magnetEntity = (AcceleratorMagneticFieldBlockEntity)blockEntity;
            if (magnetEntity.receivedRedstoneSignal() > 0) {
                return false;
            }
            long currentTick = serverWorld.getGameTime();
            if (!lastTickLogged.containsKey(magnetEntity.getBlockPos())) {
                lastTickLogged.put(magnetEntity.getBlockPos(), -1L);
                callsThisTick.put(magnetEntity.getBlockPos(), 0);
            }
            if (lastTickLogged.get(magnetEntity.getBlockPos()) != currentTick) {
                lastTickLogged.put(magnetEntity.getBlockPos(), currentTick);
                callsThisTick.put(magnetEntity.getBlockPos(), 1);
                if (lastEnergyTick.containsKey(magnetEntity.getBlockPos())) {
                    lastEnergyTick.put(magnetEntity.getBlockPos(), -1L);
                }
            } else {
                callsThisTick.put(magnetEntity.getBlockPos(), callsThisTick.get(magnetEntity.getBlockPos()) + 1);
            }
            long energyCostLong = Math.round(AcceleratorParticleLogicMixin.calculateMagneticFieldEnergyCostStatic(requiredDist, speed, magnetEntity));
            if (!lastEnergyTick.containsKey(magnetEntity.getBlockPos())) {
                lastEnergyTick.put(magnetEntity.getBlockPos(), -1L);
            }
            boolean bl = alreadyConsumedThisTick = lastEnergyTick.get(magnetEntity.getBlockPos()) == currentTick;
            if (alreadyConsumedThisTick) {
                return true;
            }
            magnetEntity.energyStorage.update();
            if (magnetEntity.energyStorage.getAmount() >= energyCostLong) {
                magnetEntity.energyStorage.amount -= energyCostLong;
                magnetEntity.energyStorage.update();
                lastEnergyTick.put(magnetEntity.getBlockPos(), currentTick);
                AcceleratorParticleLogicMixin.createMagneticFieldParticles(serverWorld, magnetEntity.getBlockPos());
                return true;
            }
        }
        return false;
    }

    private static float calculateMagneticFieldEnergyCostStatic(float requiredDist, float speed, AcceleratorMagneticFieldBlockEntity magnetEntity) {
        float totalCost = AcceleratorParticleLogicMixin.getTotalCost(requiredDist, speed);
        float efficiencyMultiplier = Math.max(0.1f, magnetEntity.getBaseAddonData().efficiency());
        return totalCost * efficiencyMultiplier;
    }

    private static float getTotalCost(float requiredDist, float speed) {
        ConfigLoader.MagneticField config = ConfigLoader.getInstance().magneticFieldSettings;
        float baseCost = config.baseCost();
        float speedCost = speed * speed / config.speedCostDivisor();
        float bendCost = requiredDist * requiredDist;
        return baseCost + speedCost + bendCost;
    }

    private static void createMagneticFieldParticles(ServerLevel world, BlockPos magnetPos) {
        Vec3 centerPos = Vec3.atCenterOf((Vec3i)magnetPos);
        double offsetX = world.random.nextDouble() - 0.5;
        double offsetY = world.random.nextDouble() * 0.5;
        double offsetZ = world.random.nextDouble() - 0.5;
        Vec3 particlePos = centerPos.add(offsetX, offsetY, offsetZ);
        world.sendParticles((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, particlePos.x, particlePos.y, particlePos.z, 1, 0.08, 0.08, 0.08, 0.05);
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void setCurrentAcceleratorContext(AcceleratorParticleLogic.ActiveParticle particle, CallbackInfo ci) {
        currentAccelerator.set(this.entity);
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void clearCurrentAcceleratorContext(AcceleratorParticleLogic.ActiveParticle particle, CallbackInfo ci) {
        currentAccelerator.remove();
    }
}

