/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.mixin;

import com.lumengrid.oritechthings.api.CrossDimensionalDrone;
import com.lumengrid.oritechthings.block.ModBlocks;
import com.lumengrid.oritechthings.item.custom.AdvancedTargetDesignator;
import com.lumengrid.oritechthings.main.ConfigLoader;
import com.lumengrid.oritechthings.main.ModDataComponents;
import com.lumengrid.oritechthings.main.OritechThings;
import dev.architectury.fluid.FluidStack;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.block.blocks.interaction.DronePortBlock;
import rearth.oritech.block.blocks.processing.MachineCoreBlock;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.block.entity.interaction.DronePortEntity;
import rearth.oritech.util.MachineAddonController;

@Mixin(value={DronePortEntity.class})
public class DronePortEntityMixin
implements CrossDimensionalDrone {
    @Shadow
    @Final
    private long baseEnergyUsage;
    @Shadow
    @Final
    private int takeOffTime;
    @Shadow
    @Final
    private int landTime;
    @Shadow
    private BlockPos targetPosition;
    @Shadow
    private long lastSentAt;
    @Shadow
    private DronePortEntity.DroneTransferData incomingPacket;
    @Shadow
    private String statusMessage;
    @Shadow
    protected SimpleContainer cardInventory;
    @Shadow
    @Final
    protected DynamicEnergyStorage energyStorage;
    @Unique
    private ResourceKey<Level> targetDimension = null;
    @Unique
    private boolean hasCrossDimensionalAddon = false;

    @Override
    public boolean oritechthings$setCrossDimensionalTarget(BlockPos targetPos, ResourceKey<Level> targetDimension) {
        boolean isCrossDimensional;
        DronePortEntity self = (DronePortEntity)this;
        if (!ConfigLoader.getInstance().dimensionalDroneSettings.enabled()) {
            return self.setTargetFromDesignator(targetPos);
        }
        assert (self.getLevel() != null);
        boolean bl = isCrossDimensional = !targetDimension.equals((Object)self.getLevel().dimension());
        if (isCrossDimensional) {
            this.validateCrossDimensionalAddonState();
            if (!this.hasCrossDimensionalAddon) {
                this.statusMessage = "message.oritechthings.drone.addon_required";
                OritechThings.LOGGER.warn("Player attempted to set cross-dimensional target at {} without Cross-Dimensional Addon at drone port {}", (Object)targetPos, (Object)self.getBlockPos());
                return false;
            }
            return this.setCrossDimensionalTarget(targetPos, targetDimension);
        }
        return self.setTargetFromDesignator(targetPos);
    }

    @Inject(method={"checkPositionCard"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkPositionCard(CallbackInfo ci) {
        try {
            DronePortEntity self = (DronePortEntity)this;
            ItemStack source = this.cardInventory.getItem(0);
            if (source == null || source.isEmpty()) {
                return;
            }
            boolean isAdvancedDesignator = source.getItem() instanceof AdvancedTargetDesignator;
            if (!isAdvancedDesignator) {
                return;
            }
            if (source.has((DataComponentType)ModDataComponents.TARGET_POSITION.get())) {
                boolean isCrossDimensional;
                BlockPos targetPos = (BlockPos)source.get((DataComponentType)ModDataComponents.TARGET_POSITION.get());
                ResourceKey targetDimension = null;
                if (ConfigLoader.getInstance().dimensionalDroneSettings.enabled() && source.has((DataComponentType)ModDataComponents.TARGET_DIMENSION.get())) {
                    targetDimension = (ResourceKey)source.get((DataComponentType)ModDataComponents.TARGET_DIMENSION.get());
                }
                if (targetDimension == null) {
                    assert (self.getLevel() != null);
                    targetDimension = self.getLevel().dimension();
                }
                assert (self.getLevel() != null);
                boolean bl = isCrossDimensional = !targetDimension.equals(self.getLevel().dimension());
                if (isCrossDimensional && !this.hasCrossDimensionalAddon) {
                    OritechThings.LOGGER.warn("Cross-dimensional transfer attempted without Cross-Dimensional Addon at drone port {}", (Object)self.getBlockPos());
                    ci.cancel();
                    return;
                }
                boolean success = this.setCrossDimensionalTarget(targetPos, (ResourceKey<Level>)targetDimension);
                if (success) {
                    this.cardInventory.setItem(1, source);
                    this.cardInventory.setItem(0, ItemStack.EMPTY);
                    this.cardInventory.setChanged();
                    self.setChanged();
                }
                ci.cancel();
            }
        }
        catch (Exception e) {
            OritechThings.LOGGER.error("DronePortEntityMixin.checkPositionCard: {}", (Object)e.getMessage());
        }
    }

    private boolean isCrossDimensional() {
        if (!ConfigLoader.getInstance().dimensionalDroneSettings.enabled()) {
            return false;
        }
        DronePortEntity self = (DronePortEntity)this;
        if (self.getLevel() != null && self.getLevel().getGameTime() % 20L == 0L) {
            this.validateCrossDimensionalAddonState();
        }
        if (!this.hasCrossDimensionalAddon) {
            return false;
        }
        if (this.targetDimension == null) {
            return false;
        }
        assert (self.getLevel() != null);
        return !this.targetDimension.equals((Object)self.getLevel().dimension());
    }

    @Unique
    private void validateCrossDimensionalAddonState() {
        DronePortEntity self = (DronePortEntity)this;
        boolean foundCrossDimensionalAddon = false;
        for (BlockPos addonPos : self.getConnectedAddons()) {
            BlockState blockState;
            if (self.getLevel() == null || !(blockState = self.getLevel().getBlockState(addonPos)).getBlock().equals(ModBlocks.ADDON_BLOCK_CROSS_DIMENSIONAL.get())) continue;
            foundCrossDimensionalAddon = true;
            break;
        }
        if (this.hasCrossDimensionalAddon != foundCrossDimensionalAddon) {
            this.hasCrossDimensionalAddon = foundCrossDimensionalAddon;
            OritechThings.LOGGER.debug("Cross-dimensional addon state changed to: {} at {}", (Object)this.hasCrossDimensionalAddon, (Object)self.getBlockPos());
        }
    }

    @Inject(method={"setTargetFromDesignator"}, at={@At(value="HEAD")}, cancellable=true)
    private void setTargetFromDesignator(BlockPos targetPos, CallbackInfoReturnable<Boolean> cir) {
        this.setCrossDimensionalTarget(targetPos, this.targetDimension);
    }

    @Inject(method={"canSend"}, at={@At(value="HEAD")}, cancellable=true)
    private void canSend(CallbackInfoReturnable<Boolean> cir) {
        if (this.isCrossDimensional()) {
            DronePortEntity self = (DronePortEntity)this;
            if (self.disabledViaRedstone || this.targetPosition == null || this.targetDimension == null || self.inventory.isEmpty() && self.fluidStorage.getAmount() == 0L || this.incomingPacket != null) {
                cir.setReturnValue((Object)false);
                return;
            }
            long currentEnergy = self.getEnergyStorage().amount;
            long requiredEnergy = this.calculateCrossDimensionalEnergyUsage();
            if (currentEnergy < requiredEnergy) {
                OritechThings.LOGGER.warn("not enough energy to jump : Current: {} Required: {}", (Object)currentEnergy, (Object)requiredEnergy);
                cir.setReturnValue((Object)false);
                return;
            }
            if (!this.validateCrossDimensionalTarget()) {
                OritechThings.LOGGER.warn("target dimension / position is not valid");
                cir.setReturnValue((Object)false);
                return;
            }
            if (self.isSendingDrone()) {
                OritechThings.LOGGER.info("is still sending drone");
                cir.setReturnValue((Object)false);
                return;
            }
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"sendDrone"}, at={@At(value="HEAD")}, cancellable=true)
    private void sendDrone(CallbackInfo ci) {
        if (this.isCrossDimensional() && this.sendCrossDimensionalDrone()) {
            ci.cancel();
        }
    }

    @Inject(method={"isSendingDrone"}, at={@At(value="RETURN")}, cancellable=true)
    private void isSendingDrone(CallbackInfoReturnable<Boolean> cir) {
        if (this.isCrossDimensional()) {
            DronePortEntity self = (DronePortEntity)this;
            assert (self.getLevel() != null);
            long diff = self.getLevel().getGameTime() - this.lastSentAt;
            cir.setReturnValue((Object)(diff < 40L ? 1 : 0));
        }
    }

    @Inject(method={"calculateEnergyUsage"}, at={@At(value="RETURN")}, cancellable=true)
    private void calculateEnergyUsage(CallbackInfoReturnable<Long> cir) {
        if (this.isCrossDimensional()) {
            cir.setReturnValue((Object)this.calculateCrossDimensionalEnergyUsage());
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        if (this.targetDimension != null) {
            nbt.putString("target_dimension", this.targetDimension.location().toString());
        }
        nbt.putBoolean("has_cross_dimensional_addon", this.hasCrossDimensionalAddon);
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup, CallbackInfo ci) {
        if (nbt.contains("target_dimension")) {
            String dimensionString = nbt.getString("target_dimension");
            try {
                ResourceLocation dimensionLocation = ResourceLocation.parse((String)dimensionString);
                this.targetDimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
            }
            catch (Exception e) {
                OritechThings.LOGGER.warn("Failed to load target dimension from NBT: {}", (Object)dimensionString, (Object)e);
                this.targetDimension = null;
            }
        }
        this.hasCrossDimensionalAddon = nbt.getBoolean("has_cross_dimensional_addon");
    }

    @Inject(method={"getAdditionalStatFromAddon"}, at={@At(value="TAIL")})
    private void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock, CallbackInfo ci) {
        if (addonBlock.state().getBlock().equals(ModBlocks.ADDON_BLOCK_CROSS_DIMENSIONAL.get())) {
            this.hasCrossDimensionalAddon = true;
        }
    }

    @Inject(method={"resetAddons"}, at={@At(value="HEAD")})
    private void resetAddons(CallbackInfo ci) {
        this.hasCrossDimensionalAddon = false;
    }

    @Inject(method={"initAddons"}, at={@At(value="TAIL")})
    private void initAddons(CallbackInfo ci) {
        DronePortEntity self = (DronePortEntity)this;
        boolean foundCrossDimensionalAddon = false;
        for (BlockPos addonPos : self.getConnectedAddons()) {
            BlockState blockState;
            if (self.getLevel() == null || !(blockState = self.getLevel().getBlockState(addonPos)).getBlock().equals(ModBlocks.ADDON_BLOCK_CROSS_DIMENSIONAL.get())) continue;
            foundCrossDimensionalAddon = true;
            break;
        }
        this.hasCrossDimensionalAddon = foundCrossDimensionalAddon;
    }

    @Unique
    private boolean setCrossDimensionalTarget(BlockPos targetPos, ResourceKey<Level> targetDimension) {
        BlockEntity targetEntity;
        MachineCoreEntity coreEntity;
        BlockPos controllerPos;
        DronePortEntity self = (DronePortEntity)this;
        this.validateCrossDimensionalAddonState();
        assert (self.getLevel() != null);
        if (!targetDimension.equals((Object)self.getLevel().dimension()) && !this.hasCrossDimensionalAddon) {
            this.statusMessage = "message.oritechthings.drone.addon_required";
            OritechThings.LOGGER.warn("Attempted to set cross-dimensional target without addon at drone port {}", (Object)self.getBlockPos());
            return false;
        }
        assert (self.getLevel() != null);
        MinecraftServer server = self.getLevel().getServer();
        if (server == null) {
            this.statusMessage = "message.oritechthings.drone.server_unavailable";
            return false;
        }
        ServerLevel targetLevel = server.getLevel(targetDimension);
        if (targetLevel == null) {
            this.statusMessage = "message.oritechthings.drone.dimension_unavailable";
            return false;
        }
        BlockState targetState = ((Level)Objects.requireNonNull(targetLevel)).getBlockState(targetPos);
        if (targetState.getBlock() instanceof MachineCoreBlock && ((Boolean)targetState.getValue((Property)MachineCoreBlock.USED)).booleanValue() && (controllerPos = Objects.requireNonNull(coreEntity = (MachineCoreEntity)targetLevel.getBlockEntity(targetPos)).getControllerPos()) != null) {
            targetPos = controllerPos;
        }
        if (!((targetEntity = targetLevel.getBlockEntity(targetPos)) instanceof DronePortEntity)) {
            this.statusMessage = "message.oritech.drone.target_invalid";
            return false;
        }
        if (!(targetLevel.getBlockState(targetPos).getBlock() instanceof DronePortBlock)) {
            this.statusMessage = "message.oritech.drone.target_invalid";
            return false;
        }
        this.targetDimension = targetDimension;
        this.targetPosition = targetPos;
        this.statusMessage = "message.oritechthings.drone.cross_dimensional_target_set";
        return true;
    }

    @Unique
    private boolean validateCrossDimensionalTarget() {
        if (this.targetDimension == null || this.targetPosition == null) {
            return false;
        }
        DronePortEntity self = (DronePortEntity)this;
        MinecraftServer server = self.getLevel().getServer();
        if (server == null) {
            return false;
        }
        ServerLevel targetLevel = server.getLevel(this.targetDimension);
        if (targetLevel == null) {
            return false;
        }
        BlockEntity targetEntity = targetLevel.getBlockEntity(this.targetPosition);
        return targetEntity instanceof DronePortEntity;
    }

    @Unique
    private long calculateCrossDimensionalEnergyUsage() {
        return this.baseEnergyUsage + (long)ConfigLoader.getInstance().dimensionalDroneSettings.energyToCross();
    }

    @Unique
    private void triggerCrossDimensionalEffects(DronePortEntity dronePort, boolean isArrival) {
        double offsetZ;
        double offsetX;
        double offsetZ2;
        double offsetX2;
        double offsetY;
        double radius;
        double angle;
        int i;
        Level level = dronePort.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockPos centerPos = this.calculateMultiblockCenter(dronePort);
        double x = (double)centerPos.getX() + 0.5;
        double y = (double)centerPos.getY() + 0.5;
        double z = (double)centerPos.getZ() + 0.5;
        for (i = 0; i < 100; ++i) {
            angle = (double)i * 0.15 + (double)serverLevel.getGameTime() * 0.1;
            radius = 1.5 + Math.sin((double)i * 0.08) * 1.0;
            offsetY = Math.sin((double)i * 0.2) * 2.0;
            offsetX2 = Math.cos(angle) * radius;
            offsetZ2 = Math.sin(angle) * radius;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x + offsetX2, y + offsetY, z + offsetZ2, 2, 0.1, 0.1, 0.1, 0.3);
        }
        for (i = 0; i < 60; ++i) {
            angle = -((double)i * 0.3) + (double)serverLevel.getGameTime() * 0.15;
            radius = 0.8 + Math.cos((double)i * 0.12) * 0.4;
            offsetY = Math.cos((double)i * 0.15) * 1.5;
            offsetX2 = Math.cos(angle) * radius;
            offsetZ2 = Math.sin(angle) * radius;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, x + offsetX2, y + offsetY, z + offsetZ2, 1, 0.05, 0.05, 0.05, 0.4);
        }
        for (i = 0; i < 40; ++i) {
            angle = Math.random() * Math.PI * 2.0;
            radius = 0.5 + Math.random() * 2.0;
            double offsetX3 = Math.cos(angle) * radius;
            double offsetZ3 = Math.sin(angle) * radius;
            double offsetY2 = Math.random() * 2.5;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.END_ROD, x + offsetX3, y + offsetY2, z + offsetZ3, 1, 0.05, 0.05, 0.05, 0.1);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, x + offsetX3, y + offsetY2, z + offsetZ3, 1, 0.1, 0.1, 0.1, 0.2);
        }
        for (i = 0; i < 30; ++i) {
            offsetX = (Math.random() - 0.5) * 3.0;
            offsetZ = (Math.random() - 0.5) * 3.0;
            offsetY = Math.random() * 3.0;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.WARPED_SPORE, x + offsetX, y + offsetY, z + offsetZ, 1, 0.1, 0.1, 0.1, 0.05);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIMSON_SPORE, x + offsetX, y + offsetY, z + offsetZ, 1, 0.1, 0.1, 0.1, 0.05);
        }
        for (i = 0; i < 20; ++i) {
            offsetX = (Math.random() - 0.5) * 4.0;
            offsetZ = (Math.random() - 0.5) * 4.0;
            offsetY = Math.random() * 3.0;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, x + offsetX, y + offsetY, z + offsetZ, 1, 0.02, 0.02, 0.02, 0.02);
        }
        if (isArrival) {
            serverLevel.playSound(null, centerPos, SoundEvents.PORTAL_TRAVEL, SoundSource.BLOCKS, 1.2f, 1.0f);
            serverLevel.playSound(null, centerPos, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.2f);
            serverLevel.playSound(null, centerPos, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 0.8f, 0.8f);
            serverLevel.playSound(null, centerPos, SoundEvents.END_PORTAL_SPAWN, SoundSource.BLOCKS, 0.6f, 1.8f);
            OritechThings.LOGGER.info("Cross-dimensional arrival effects triggered at {} in dimension {}", (Object)centerPos, (Object)serverLevel.dimension().location());
        } else {
            serverLevel.playSound(null, centerPos, SoundEvents.PORTAL_TRAVEL, SoundSource.BLOCKS, 1.5f, 0.7f);
            serverLevel.playSound(null, centerPos, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.BLOCKS, 1.2f, 0.8f);
            serverLevel.playSound(null, centerPos, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 1.0f, 1.2f);
            serverLevel.playSound(null, centerPos, SoundEvents.END_PORTAL_SPAWN, SoundSource.BLOCKS, 0.8f, 1.5f);
        }
    }

    @Unique
    private BlockPos calculateMultiblockCenter(DronePortEntity dronePort) {
        BlockPos controllerPos = dronePort.getBlockPos();
        Direction facing = dronePort.getFacingForMultiblock();
        return controllerPos.relative(facing);
    }

    @Inject(method={"checkIncomingAnimation"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkIncomingAnimation(CallbackInfo ci) {
        if (this.incomingPacket != null && this.isCrossDimensionalPacket()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isCrossDimensionalPacket() {
        if (this.incomingPacket == null) {
            return false;
        }
        DronePortEntity self = (DronePortEntity)this;
        long expectedNormalTime = this.takeOffTime + this.landTime;
        long expectedCrossDimensionalTime = this.landTime;
        long currentTime = self.getLevel().getGameTime();
        long timeSinceSent = currentTime - (this.incomingPacket.arrivesAt() - expectedNormalTime);
        long timeSinceCrossDimensional = currentTime - (this.incomingPacket.arrivesAt() - expectedCrossDimensionalTime);
        return Math.abs(timeSinceCrossDimensional) < Math.abs(timeSinceSent);
    }

    @Unique
    private boolean sendCrossDimensionalDrone() {
        DronePortEntity self = (DronePortEntity)this;
        assert (self.getLevel() != null);
        MinecraftServer server = self.getLevel().getServer();
        if (server == null) {
            OritechThings.LOGGER.error("Cannot perform cross-dimensional transfer: server is null");
            return false;
        }
        ServerLevel targetLevel = server.getLevel(this.targetDimension);
        if (targetLevel == null) {
            OritechThings.LOGGER.error("Cannot access target dimension: {}", this.targetDimension);
            return false;
        }
        BlockEntity targetEntity = targetLevel.getBlockEntity(this.targetPosition);
        if (!(targetEntity instanceof DronePortEntity)) {
            OritechThings.LOGGER.error("Target is not a drone port at: {} in {}", (Object)this.targetPosition, this.targetDimension);
            return false;
        }
        DronePortEntity targetPort = (DronePortEntity)targetEntity;
        long arriveTime = targetLevel.getGameTime() + 20L;
        DronePortEntity.DroneTransferData data = new DronePortEntity.DroneTransferData(self.inventory.getHeldStacks().stream().filter(stack -> !stack.isEmpty()).toList(), self.fluidStorage.getStack(), arriveTime);
        targetPort.setIncomingPacket(data);
        self.inventory.clearContent();
        self.fluidStorage.setStack(FluidStack.empty());
        this.lastSentAt = self.getLevel().getGameTime();
        this.energyStorage.amount -= this.calculateCrossDimensionalEnergyUsage();
        this.triggerCrossDimensionalEffects(self, false);
        this.scheduleCrossDimensionalArrival(targetPort, (Level)targetLevel, 20);
        targetPort.setChanged();
        self.setChanged();
        OritechThings.LOGGER.info("Cross-dimensional drone sent from {} to {} in dimension {} (arrives in {} ticks)", new Object[]{self.getBlockPos(), this.targetPosition, this.targetDimension.location(), arriveTime - self.getLevel().getGameTime()});
        return true;
    }

    @Unique
    private void scheduleCrossDimensionalArrival(DronePortEntity targetPort, Level targetLevel, int delayTicks) {
        if (targetLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)targetLevel;
            serverLevel.getServer().tell((Runnable)new TickTask(serverLevel.getServer().getTickCount() + delayTicks, () -> this.triggerCrossDimensionalEffects(targetPort, true)));
        }
    }
}

