/*
 * Decompiled with CFR 0.152.
 */
package dev.nalo.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ModConfig {
    public boolean disableThirdPersonFront = true;
    public float cameraSmooth = 0.2f;
    public float cameraOffset = 20.0f;
    public boolean showHUD = true;
    public String ballItemId = "minecraft:target";
    public transient class_1792 ballItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(this.ballItemId));
    public boolean showBallMarker = true;
    public float ballMarkerRadius = 2.0f;
    public float ballMarkerThickness = 0.2f;
    public String ballMarkerColorHex = "#FFFFFF";
    public transient Color ballMarkerColor = Color.WHITE;
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("blocketleagueutils.json");

    public static ModConfig load() {
        ModConfig config;
        if (Files.exists(FILE, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(FILE);){
                config = (ModConfig)new Gson().fromJson((Reader)reader, ModConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                config = new ModConfig();
            }
        } else {
            config = new ModConfig();
        }
        config.ballItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(config.ballItemId));
        try {
            config.ballMarkerColor = Color.decode(config.ballMarkerColorHex);
        }
        catch (NumberFormatException e) {
            config.ballMarkerColor = Color.WHITE;
            config.ballMarkerColorHex = "#FFFFFF";
        }
        return config;
    }

    public void save() {
        class_2960 id = class_7923.field_41178.method_10221((Object)this.ballItem);
        if (id != null) {
            this.ballItemId = id.toString();
        }
        this.ballMarkerColorHex = String.format("#%06X", 0xFFFFFF & this.ballMarkerColor.getRGB());
        try (BufferedWriter writer = Files.newBufferedWriter(FILE, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)this, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

