/*
 * Decompiled with CFR 0.152.
 */
package com.github.kazuofficial.blockexporter;

import com.github.kazuofficial.blockexporter.BlockExporter;
import com.github.kazuofficial.blockexporter.ItemRenderer;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ExportScreen
extends class_437 {
    private static final int PROGRESS_BAR_WIDTH = 280;
    private static final int PROGRESS_BAR_HEIGHT = 24;
    private static final int ITEM_SIZE = 48;
    private static final int PANEL_PADDING = 20;
    private static final int PROGRESS_BACKGROUND = -13816528;
    private static final int PROGRESS_FILL = -15828210;
    private static final int PROGRESS_BORDER = -11184811;
    private static final int ITEM_FRAME_COLOR = -7631989;
    private static final int ACCENT_COLOR = -11890462;
    private static final int BATCH_SIZE = 32;
    private final List<class_1792> allItems;
    private List<class_1792> itemsToExport;
    private boolean finishedWithErrors = false;
    private int failedItemCount = 0;
    private int currentItemIndex = 0;
    private final AtomicInteger completedItems = new AtomicInteger(0);
    private boolean isExporting = false;
    private class_4185 startCancelButton;
    private class_4185 doneButton;
    private ItemRenderer itemRenderer;
    private int exportSize = 64;
    private Path exportDirectory;
    private class_357 sizeSlider;
    private static final List<Integer> EXPORT_SIZES = Arrays.asList(16, 32, 64, 128, 256, 512, 1024);

    public ExportScreen() {
        super((class_2561)class_2561.method_43471((String)"screen.blockexporter.title"));
        this.allItems = new ArrayList<class_1792>(class_7923.field_41178.method_10220().filter(item -> item != class_1802.field_8162).toList());
        this.itemsToExport = new ArrayList<class_1792>(this.allItems);
    }

    protected void method_25426() {
        super.method_25426();
        this.exportDirectory = this.field_22787.field_1697.toPath().resolve("item_exports");
        int buttonWidth = 100;
        int buttonHeight = 24;
        int spacing = 12;
        int totalWidth = buttonWidth * 3 + spacing * 2;
        int buttonsX = (this.field_22789 - totalWidth) / 2;
        int sliderWidth = 240;
        this.sizeSlider = new class_357(this.field_22789 / 2 - sliderWidth / 2, this.field_22790 - 75, sliderWidth, 20, (class_2561)class_2561.method_43473(), 0.0){
            {
                int initialSizeIndex = EXPORT_SIZES.indexOf(ExportScreen.this.exportSize);
                if (initialSizeIndex == -1) {
                    initialSizeIndex = 2;
                }
                this.field_22753 = (double)initialSizeIndex / (double)(EXPORT_SIZES.size() - 1);
                this.method_25344();
                this.method_25346();
            }

            protected void method_25346() {
                int size = EXPORT_SIZES.get((int)Math.round(this.field_22753 * (double)(EXPORT_SIZES.size() - 1)));
                this.method_25355((class_2561)class_2561.method_43470((String)("Export Size: " + size + "\u00d7" + size + " pixels")));
            }

            protected void method_25344() {
                int sizeIndex = (int)Math.round(this.field_22753 * (double)(EXPORT_SIZES.size() - 1));
                ExportScreen.this.exportSize = EXPORT_SIZES.get(sizeIndex);
            }
        };
        this.method_37063((class_364)this.sizeSlider);
        this.startCancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.isExporting ? "Cancel Export" : "\u25b6 Start Export")), button -> {
            if (this.isExporting) {
                this.isExporting = false;
                this.updateButtonStates();
                BlockExporter.LOGGER.info("Export cancelled by user.");
            } else {
                this.isExporting = true;
                this.finishedWithErrors = false;
                this.failedItemCount = 0;
                this.itemsToExport = new ArrayList<class_1792>(this.allItems);
                if (this.itemRenderer != null) {
                    this.itemRenderer.close();
                }
                this.itemRenderer = new ItemRenderer(this.exportSize);
                this.currentItemIndex = 0;
                this.completedItems.set(0);
                BlockExporter.LOGGER.info("Starting fast batch export of {} items with batch size {}", (Object)this.itemsToExport.size(), (Object)32);
                this.updateButtonStates();
            }
        }).method_46434(buttonsX, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udcc1 Open Folder"), button -> {
            try {
                Files.createDirectories(this.exportDirectory, new FileAttribute[0]);
                class_156.method_668().method_672(this.exportDirectory.toFile());
            }
            catch (IOException e) {
                BlockExporter.LOGGER.error("Couldn't open export folder", (Throwable)e);
            }
        }).method_46434(buttonsX + buttonWidth + spacing, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431());
        this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(buttonsX + (buttonWidth + spacing) * 2, this.field_22790 - 40, buttonWidth, buttonHeight).method_46431());
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.isExporting) {
            this.startCancelButton.method_25355((class_2561)class_2561.method_43470((String)"Cancel Export"));
            this.sizeSlider.field_22763 = false;
            this.doneButton.field_22763 = false;
        } else {
            this.startCancelButton.method_25355((class_2561)class_2561.method_43470((String)"\u25b6 Start Export"));
            this.sizeSlider.field_22763 = true;
            this.doneButton.field_22763 = true;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        String statusText;
        this.method_52752(context);
        int panelHeight = 240;
        int panelY = (this.field_22790 - panelHeight) / 2 - 20;
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, panelY + 20, -11890462);
        int itemSectionY = panelY + 20 + 25;
        int displayIndex = Math.min(this.currentItemIndex, this.itemsToExport.size() - 1);
        if (displayIndex >= 0 && displayIndex < this.itemsToExport.size()) {
            class_1799 stack = new class_1799((class_1935)this.itemsToExport.get(displayIndex));
            int itemFrameSize = 56;
            int itemFrameX = (this.field_22789 - itemFrameSize) / 2;
            int itemFrameY = itemSectionY;
            context.method_25294(itemFrameX - 1, itemFrameY - 1, itemFrameX + itemFrameSize + 1, itemFrameY + itemFrameSize + 1, -7631989);
            context.method_25294(itemFrameX, itemFrameY, itemFrameX + itemFrameSize, itemFrameY + itemFrameSize, -14803426);
            int itemX = itemFrameX + 4;
            int itemY = itemFrameY + 4;
            context.method_51448().pushMatrix();
            context.method_51448().translate((float)itemX + 24.0f, (float)itemY + 24.0f);
            context.method_51448().scale(3.0f, 3.0f);
            context.method_51448().translate(-8.0f, -8.0f);
            context.method_51427(stack, 0, 0);
            context.method_51448().popMatrix();
            Object itemName = stack.method_7964().getString();
            if (((String)itemName).length() > 25) {
                itemName = ((String)itemName).substring(0, 22) + "...";
            }
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)itemName), this.field_22789 / 2, itemSectionY + itemFrameSize + 8, -1);
            if (mouseX >= itemX && mouseX < itemX + 48 && mouseY >= itemY && mouseY < itemY + 48) {
                context.method_51446(this.field_22793, stack, mouseX, mouseY);
            }
        }
        int progressSectionY = itemSectionY + 85;
        int progressX = (this.field_22789 - 280) / 2;
        int progressY = progressSectionY;
        context.method_25294(progressX - 1, progressY - 1, progressX + 280 + 1, progressY + 24 + 1, -11184811);
        context.method_25294(progressX, progressY, progressX + 280, progressY + 24, -13816528);
        boolean isComplete = this.currentItemIndex >= this.itemsToExport.size() && !this.isExporting;
        int completed = isComplete ? this.itemsToExport.size() - this.failedItemCount : this.completedItems.get();
        float progress = this.itemsToExport.isEmpty() ? 0.0f : (float)completed / (float)this.itemsToExport.size();
        int progressWidth = (int)(280.0f * progress);
        if (progressWidth > 0) {
            context.method_25294(progressX, progressY, progressX + progressWidth, progressY + 24, -15828210);
            context.method_25294(progressX, progressY, progressX + progressWidth, progressY + 2, -11751600);
        }
        String progressText = String.format("%d / %d items (%.1f%%)", completed, this.itemsToExport.size(), Float.valueOf(progress * 100.0f));
        context.method_25300(this.field_22793, progressText, this.field_22789 / 2, progressY + 24 + 8, -1);
        String string = this.isExporting ? "\u26a1 Exporting..." : (isComplete ? (this.finishedWithErrors ? "Finished with errors" : "Export Complete!") : (statusText = "Ready to export"));
        int statusColor = this.isExporting ? -22016 : (isComplete ? (this.finishedWithErrors ? -43691 : -16711936) : -6250336);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)statusText), this.field_22789 / 2, progressY + 24 + 25, statusColor);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25393() {
        super.method_25393();
        if (this.isExporting) {
            if (this.currentItemIndex < this.itemsToExport.size()) {
                ArrayList<class_1799> batch = new ArrayList<class_1799>();
                int batchEnd = Math.min(this.currentItemIndex + 32, this.itemsToExport.size());
                for (int i = this.currentItemIndex; i < batchEnd; ++i) {
                    batch.add(new class_1799((class_1935)this.itemsToExport.get(i)));
                }
                if (this.itemRenderer != null && !batch.isEmpty()) {
                    this.itemRenderer.exportItemsBatch(batch, this.completedItems);
                }
                this.currentItemIndex = batchEnd;
            } else if (this.completedItems.get() >= this.itemsToExport.size()) {
                List<class_1799> currentFailedItems;
                this.isExporting = false;
                if (this.itemRenderer != null && !(currentFailedItems = this.itemRenderer.getFailedExports()).isEmpty()) {
                    this.finishedWithErrors = true;
                    this.failedItemCount = currentFailedItems.size();
                }
                this.updateButtonStates();
                if (!this.finishedWithErrors) {
                    BlockExporter.LOGGER.info("Fast batch export completed! Exported {} items", (Object)this.itemsToExport.size());
                } else {
                    BlockExporter.LOGGER.warn("Export finished with {} failures.", (Object)this.failedItemCount);
                }
            }
        }
    }

    public void method_25419() {
        if (this.itemRenderer != null) {
            this.itemRenderer.close();
        }
        super.method_25419();
    }

    public boolean method_25421() {
        return true;
    }
}

