/*
 * Decompiled with CFR 0.152.
 */
package com.github.kazuofficial.blockexporter;

import com.github.kazuofficial.blockexporter.BlockExporter;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_10366;
import net.minecraft.class_10444;
import net.minecraft.class_11286;
import net.minecraft.class_11659;
import net.minecraft.class_11684;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_6367;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_9848;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class ItemRenderer
implements AutoCloseable {
    private final int textureSize;
    private final Path exportDirectory;
    private final class_310 client;
    private final class_6367 framebuffer;
    private final class_11286 projectionMatrix;
    private final class_10444 itemRenderState;
    private final ExecutorService fileWriteExecutor;
    private final Semaphore fileWriteSemaphore;
    private final ConcurrentLinkedQueue<class_1799> failedExports;
    private final class_4587 matrices;
    private final Matrix4f orthoMatrix;
    private final class_11659 renderCommandQueue;
    private final class_11684 renderDispatcher;
    private final class_4597.class_4598 vertexConsumers;

    public ItemRenderer(int textureSize) {
        this.textureSize = textureSize;
        this.client = class_310.method_1551();
        this.exportDirectory = this.client.field_1697.toPath().resolve("item_exports");
        this.projectionMatrix = new class_11286("item-exporter");
        this.itemRenderState = new class_10444();
        int coreCount = Runtime.getRuntime().availableProcessors();
        this.fileWriteExecutor = Executors.newFixedThreadPool(Math.max(2, coreCount / 2));
        this.fileWriteSemaphore = new Semaphore(coreCount);
        this.failedExports = new ConcurrentLinkedQueue();
        this.matrices = new class_4587();
        this.orthoMatrix = new Matrix4f().setOrtho(0.0f, (float)this.textureSize, (float)this.textureSize, 0.0f, -1000.0f, 1000.0f);
        this.renderCommandQueue = this.client.field_1773.method_72910();
        this.renderDispatcher = this.client.field_1773.method_72911();
        this.vertexConsumers = this.client.method_22940().method_23000();
        try {
            Files.createDirectories(this.exportDirectory, new FileAttribute[0]);
            BlockExporter.LOGGER.info("Created export directory: {}", (Object)this.exportDirectory.toAbsolutePath());
        }
        catch (IOException e) {
            BlockExporter.LOGGER.error("Failed to create export directory: {}", (Object)this.exportDirectory.toAbsolutePath(), (Object)e);
            throw new RuntimeException("Failed to create export directory", e);
        }
        this.framebuffer = new class_6367("item-exporter", this.textureSize, this.textureSize, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportItemsBatch(List<class_1799> stacks, AtomicInteger completionCounter) {
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        GpuTextureView oldColor = RenderSystem.outputColorTextureOverride;
        GpuTextureView oldDepth = RenderSystem.outputDepthTextureOverride;
        try {
            RenderSystem.outputColorTextureOverride = this.framebuffer.method_71639();
            RenderSystem.outputDepthTextureOverride = this.framebuffer.method_71640();
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrix.method_71123(this.orthoMatrix), (class_10366)class_10366.field_54954);
            for (class_1799 stack : stacks) {
                if (stack == null || stack.method_7960()) continue;
                this.exportSingleItemFast(stack, completionCounter);
            }
        }
        catch (Exception e) {
            BlockExporter.LOGGER.error("Failed to export item batch", (Throwable)e);
        }
        finally {
            RenderSystem.outputColorTextureOverride = oldColor;
            RenderSystem.outputDepthTextureOverride = oldDepth;
        }
    }

    private void exportSingleItemFast(class_1799 stack, AtomicInteger completionCounter) {
        class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
        try {
            this.client.method_65386().method_65598(this.itemRenderState, stack, class_811.field_4317, (class_1937)this.client.field_1687, null, 0);
            CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
            commandEncoder.clearColorAndDepthTextures(this.framebuffer.method_30277(), 0, this.framebuffer.method_30278(), 1.0);
            this.matrices.method_22903();
            this.matrices.method_22904((double)this.textureSize / 2.0, (double)this.textureSize / 2.0, 100.0);
            this.matrices.method_22905((float)this.textureSize, (float)(-this.textureSize), (float)this.textureSize);
            if (this.itemRenderState.method_65608()) {
                this.client.field_1773.method_71114().method_71034(class_308.class_11274.field_60027);
            } else {
                this.client.field_1773.method_71114().method_71034(class_308.class_11274.field_60026);
            }
            this.itemRenderState.method_65604(this.matrices, this.renderCommandQueue, 0xF000F0, class_4608.field_21444, 0);
            this.matrices.method_22909();
            this.renderDispatcher.method_73002();
            this.vertexConsumers.method_22993();
            this.takeScreenshotAsync((class_276)this.framebuffer, id, stack, completionCounter);
        }
        catch (Exception e) {
            BlockExporter.LOGGER.error("Failed to export item: {}", (Object)id, (Object)e);
            this.failedExports.add(stack);
            completionCounter.incrementAndGet();
        }
    }

    private void takeScreenshotAsync(class_276 framebuffer, class_2960 itemId, class_1799 itemStack, AtomicInteger completionCounter) {
        ItemRenderer.takeScreenshot(framebuffer, image -> CompletableFuture.runAsync(() -> {
            try {
                this.fileWriteSemaphore.acquire();
                Path filePath = this.exportDirectory.resolve(itemId.method_12836() + "_" + itemId.method_12832() + ".png");
                image.method_4314(filePath);
                BlockExporter.LOGGER.debug("Async exported: {}", (Object)filePath.getFileName());
            }
            catch (IOException e) {
                BlockExporter.LOGGER.error("Failed to save exported item image: {}", (Object)itemId, (Object)e);
                this.failedExports.add(itemStack);
            }
            catch (InterruptedException e) {
                BlockExporter.LOGGER.error("Screenshot thread interrupted for item: {}", (Object)itemId, (Object)e);
                this.failedExports.add(itemStack);
                Thread.currentThread().interrupt();
            }
            finally {
                if (image != null) {
                    image.close();
                }
                this.fileWriteSemaphore.release();
                completionCounter.incrementAndGet();
            }
        }, this.fileWriteExecutor));
    }

    public static void takeScreenshot(class_276 framebuffer, Consumer<class_1011> callback) {
        ItemRenderer.takeScreenshot(framebuffer, 1, callback);
    }

    public static void takeScreenshot(class_276 framebuffer, int downscaleFactor, Consumer<class_1011> callback) {
        int i = framebuffer.field_1482;
        int j = framebuffer.field_1481;
        GpuTexture gpuTexture = framebuffer.method_30277();
        if (gpuTexture == null) {
            throw new IllegalStateException("Tried to capture screenshot of an incomplete framebuffer");
        }
        if (i % downscaleFactor != 0 || j % downscaleFactor != 0) {
            throw new IllegalArgumentException("Image size is not divisible by downscale factor");
        }
        GpuBuffer gpuBuffer = RenderSystem.getDevice().createBuffer(() -> "Screenshot buffer", 9, i * j * gpuTexture.getFormat().pixelSize());
        CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
        RenderSystem.getDevice().createCommandEncoder().copyTextureToBuffer(gpuTexture, gpuBuffer, 0, () -> {
            try (GpuBuffer.MappedView mappedView = commandEncoder.mapBuffer(gpuBuffer, true, false);){
                int l = j / downscaleFactor;
                int m = i / downscaleFactor;
                class_1011 nativeImage = new class_1011(m, l, false);
                for (int n = 0; n < l; ++n) {
                    for (int o = 0; o < m; ++o) {
                        int s;
                        int p;
                        if (downscaleFactor == 1) {
                            p = mappedView.data().getInt((o + n * i) * gpuTexture.getFormat().pixelSize());
                            nativeImage.method_4305(o, j - n - 1, p);
                            continue;
                        }
                        p = 0;
                        int q = 0;
                        int r = 0;
                        int a = 0;
                        for (s = 0; s < downscaleFactor; ++s) {
                            for (int t = 0; t < downscaleFactor; ++t) {
                                int u = mappedView.data().getInt((o * downscaleFactor + s + (n * downscaleFactor + t) * i) * gpuTexture.getFormat().pixelSize());
                                p += class_9848.method_61327((int)u);
                                q += class_9848.method_61329((int)u);
                                r += class_9848.method_61331((int)u);
                                a += class_9848.method_61320((int)u);
                            }
                        }
                        s = downscaleFactor * downscaleFactor;
                        nativeImage.method_4305(o, l - n - 1, class_9848.method_61324((int)(a / s), (int)(p / s), (int)(q / s), (int)(r / s)));
                    }
                }
                callback.accept(nativeImage);
            }
            gpuBuffer.close();
        }, 0);
    }

    public List<class_1799> getFailedExports() {
        return List.copyOf(this.failedExports);
    }

    @Override
    public void close() {
        this.fileWriteExecutor.shutdown();
        this.projectionMatrix.close();
        this.framebuffer.method_1238();
    }
}

