/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.client.tesr;

import com.blakebr0.mysticalagriculture.tileentity.SouliumSpawnerTileEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class SouliumSpawnerRenderer
implements BlockEntityRenderer<SouliumSpawnerTileEntity> {
    private final EntityRenderDispatcher entityRenderer;

    public SouliumSpawnerRenderer(BlockEntityRendererProvider.Context context) {
        this.entityRenderer = context.getEntityRenderer();
    }

    public void render(SouliumSpawnerTileEntity tile, float v, PoseStack matrix, MultiBufferSource buffer, int i, int i1) {
        matrix.pushPose();
        matrix.translate(0.5f, 0.0f, 0.5f);
        SouliumSpawnerTileEntity.DisplayEntity displayEntity = tile.getDisplayEntity();
        if (displayEntity != null) {
            Entity entity = displayEntity.entity();
            float scale = 0.53125f;
            float bbMax = Math.max(entity.getBbWidth(), entity.getBbHeight());
            if ((double)bbMax > 1.0) {
                scale /= bbMax;
            }
            matrix.translate(0.0f, 0.4f, 0.0f);
            matrix.mulPose(Axis.YP.rotationDegrees((float)Mth.lerp((double)v, (double)tile.getoSpin(), (double)tile.getSpin()) * 10.0f));
            matrix.translate(0.0f, -0.2f, 0.0f);
            matrix.mulPose(Axis.XP.rotationDegrees(-30.0f));
            matrix.scale(scale, scale, scale);
            this.entityRenderer.render(entity, 0.0, 0.0, 0.0, 0.0f, v, matrix, buffer, i);
        }
        matrix.popPose();
    }
}

