/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat;

import com.blakebr0.mysticalagriculture.MysticalAgriculture;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.block.InferiumCropBlock;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.block.MysticalCropBlock;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public class JadeCompat
implements IWailaPlugin {
    private static final ResourceLocation CROP_PROVIDER = MysticalAgriculture.resource("crop");
    private static final ResourceLocation INFERIUM_CROP_PROVIDER = MysticalAgriculture.resource("inferium_crop");
    private static final ResourceLocation INFUSED_FARMLAND_PROVIDER = MysticalAgriculture.resource("infused_farmland");

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                ResourceKey biome;
                Set<ResourceLocation> biomes;
                Block crux;
                double secondaryChance;
                Block farmland;
                Block block = accessor.getBlock();
                Crop crop = ((ICropProvider)block).getCrop();
                tooltip.add((Component)ModTooltips.TIER.args(new Object[]{crop.getTier().getDisplayName()}).build());
                BlockPos pos = accessor.getPosition();
                BlockPos downPos = pos.below();
                Level level = accessor.getLevel();
                Block belowBlock = level.getBlockState(downPos).getBlock();
                if (((Boolean)ModConfigs.REQUIRES_EFFECTIVE_FARMLAND.get()).booleanValue() && crop != ModCrops.INFERIUM && (farmland = crop.getTier().getFarmland()) != null) {
                    tooltip.add((Component)ModTooltips.REQUIRES_EFFECTIVE_FARMLAND.args(new Object[]{farmland.getName().withStyle(crop.getTier().getTextColor())}).build());
                }
                if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && (secondaryChance = crop.getSecondaryChance(belowBlock)) > 0.0) {
                    MutableComponent chanceText = Component.literal((String)String.valueOf((int)(secondaryChance * 100.0))).append("%").withStyle(crop.getTier().getTextColor());
                    tooltip.add((Component)ModTooltips.SECONDARY_CHANCE.args(new Object[]{chanceText}).build());
                }
                if ((crux = crop.getCruxBlock()) != null) {
                    ItemStack stack = new ItemStack((ItemLike)crux);
                    tooltip.add((Component)ModTooltips.REQUIRES_CRUX.args(new Object[]{stack.getHoverName()}).build());
                }
                if (!(biomes = crop.getRequiredBiomes()).isEmpty() && (biome = level.getBiome(pos).getKey()) != null && !biomes.contains(biome.location())) {
                    tooltip.add((Component)ModTooltips.INVALID_BIOME.color(ChatFormatting.RED).build());
                }
            }

            public ResourceLocation getUid() {
                return CROP_PROVIDER;
            }
        }, MysticalCropBlock.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                Block block = accessor.getBlock();
                Crop crop = ((ICropProvider)block).getCrop();
                BlockPos downPos = accessor.getPosition().below();
                Block belowBlock = accessor.getLevel().getBlockState(downPos).getBlock();
                int output = 100;
                if (belowBlock instanceof IEssenceFarmland) {
                    IEssenceFarmland farmland = (IEssenceFarmland)belowBlock;
                    int tier = farmland.getTier().getValue();
                    output = tier * 50 + 50;
                }
                MutableComponent inferiumOutputText = Component.literal((String)String.valueOf(output)).append("%").withStyle(crop.getTier().getTextColor());
                tooltip.add((Component)ModTooltips.INFERIUM_OUTPUT.args(new Object[]{inferiumOutputText}).build());
            }

            public ResourceLocation getUid() {
                return INFERIUM_CROP_PROVIDER;
            }
        }, InferiumCropBlock.class);
        registration.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                Block block = accessor.getBlock();
                IEssenceFarmland farmland = (IEssenceFarmland)block;
                tooltip.add((Component)ModTooltips.TIER.args(new Object[]{farmland.getTier().getDisplayName()}).build());
            }

            public ResourceLocation getUid() {
                return INFUSED_FARMLAND_PROVIDER;
            }
        }, InfusedFarmlandBlock.class);
    }
}

