/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class FarmlandTillRecipe
extends ShapelessRecipe {
    private final ItemStack result;

    public FarmlandTillRecipe(String group, ItemStack result, NonNullList<Ingredient> inputs) {
        super(group, CraftingBookCategory.MISC, result, inputs);
        this.result = result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inventory) {
        NonNullList remaining = super.getRemainingItems((RecipeInput)inventory);
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!(stack.getItem() instanceof HoeItem)) continue;
            ItemStack hoe = stack.copy();
            if (hoe.isDamageableItem()) {
                int damage = hoe.getDamageValue() + 1;
                hoe.setDamageValue(damage);
                if (damage >= hoe.getMaxDamage()) continue;
                remaining.set(i, (Object)hoe);
                continue;
            }
            remaining.set(i, (Object)hoe);
        }
        return remaining;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_FARMLAND_TILL.get();
    }

    public static class Serializer
    implements RecipeSerializer<FarmlandTillRecipe> {
        public static final MapCodec<FarmlandTillRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(ShapelessRecipe::getGroup), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(field -> {
            Object[] ingredients = (Ingredient[])field.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return ingredients.length > ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth() ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(ShapedRecipePattern.getMaxHeight() * ShapedRecipePattern.getMaxWidth())) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(ShapelessRecipe::getIngredients)).apply((Applicative)builder, FarmlandTillRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FarmlandTillRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FarmlandTillRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FarmlandTillRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FarmlandTillRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = buffer.readUtf(Short.MAX_VALUE);
            int size = buffer.readVarInt();
            NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
            inputs.replaceAll(ignored -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new FarmlandTillRecipe(group, result, (NonNullList<Ingredient>)inputs);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FarmlandTillRecipe recipe) {
            buffer.writeUtf(recipe.getGroup());
            buffer.writeVarInt(recipe.getIngredients().size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

