/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.crafting.ingredient.FilledSoulJarIngredient;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SoulJarEmptyRecipe
extends ShapelessRecipe {
    public SoulJarEmptyRecipe(ItemStack result, NonNullList<Ingredient> inputs) {
        super("", CraftingBookCategory.MISC, result, inputs);
    }

    public boolean matches(CraftingInput inventory, Level level) {
        boolean hasJar = false;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (hasJar && !stack.isEmpty()) {
                return false;
            }
            Item item = stack.getItem();
            if (item instanceof SoulJarItem) {
                double souls = MobSoulUtils.getSouls(stack);
                if (!(souls > 0.0)) continue;
                hasJar = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return hasJar;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.CRAFTING_SOUL_JAR_EMPTY.get();
    }

    public static class Serializer
    implements RecipeSerializer<SoulJarEmptyRecipe> {
        public static final MapCodec<SoulJarEmptyRecipe> CODEC = MapCodec.unit(() -> new SoulJarEmptyRecipe(new ItemStack((ItemLike)ModItems.SOUL_JAR.get()), (NonNullList<Ingredient>)NonNullList.withSize((int)1, (Object)FilledSoulJarIngredient.of())));
        public static final StreamCodec<RegistryFriendlyByteBuf, SoulJarEmptyRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SoulJarEmptyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SoulJarEmptyRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SoulJarEmptyRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new SoulJarEmptyRecipe(new ItemStack((ItemLike)ModItems.SOUL_JAR.get()), (NonNullList<Ingredient>)NonNullList.withSize((int)1, (Object)FilledSoulJarIngredient.of()));
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SoulJarEmptyRecipe recipe) {
        }
    }
}

