/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.CachedRecipe;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.inventory.SidedInventoryWrapper;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.ISoulExtractionRecipe;
import com.blakebr0.mysticalagriculture.api.machine.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.api.machine.MachineUpgradeTier;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.block.SoulExtractorBlock;
import com.blakebr0.mysticalagriculture.container.SoulExtractorContainer;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.item.SoulJarItem;
import com.blakebr0.mysticalagriculture.util.RecipeIngredientCache;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class SoulExtractorTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 100;
    public static final int FUEL_USAGE = 40;
    public static final int FUEL_CAPACITY = 80000;
    private final BaseItemStackHandler inventory = SoulExtractorTileEntity.createInventoryHandler(slot -> this.setChanged());
    private final MachineUpgradeItemStackHandler upgradeInventory = new MachineUpgradeItemStackHandler();
    private final DynamicEnergyStorage energy = new DynamicEnergyStorage(80000, () -> ((SoulExtractorTileEntity)this).setChangedFast());
    private final SidedInventoryWrapper[] sidedInventoryWrappers = SidedInventoryWrapper.create((BaseItemStackHandler)this.inventory, List.of(Direction.UP, Direction.DOWN, Direction.NORTH), this::canInsertStackSided, null);
    private final CachedRecipe<CraftingInput, ISoulExtractionRecipe> recipe = new CachedRecipe((RecipeType)ModRecipeTypes.SOUL_EXTRACTION.get());
    private MachineUpgradeTier tier;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private boolean isRunning;

    public SoulExtractorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.SOUL_EXTRACTOR.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.loadAdditional(tag, lookup);
        this.progress = tag.getInt("Progress");
        this.fuelLeft = tag.getInt("FuelLeft");
        this.fuelItemValue = tag.getInt("FuelItemValue");
        this.energy.deserializeNBT(lookup, tag.get("Energy"));
        this.upgradeInventory.deserializeNBT(lookup, tag.getCompound("UpgradeInventory"));
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider lookup) {
        super.saveAdditional(tag, lookup);
        tag.putInt("Progress", this.progress);
        tag.putInt("FuelLeft", this.fuelLeft);
        tag.putInt("FuelItemValue", this.fuelItemValue);
        tag.putInt("Energy", this.energy.getEnergyStored());
        tag.put("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT(lookup));
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.mysticalagriculture.soul_extractor").build();
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return SoulExtractorContainer.create(id, playerInventory, this.inventory, this.upgradeInventory, this.getBlockPos());
    }

    @Override
    public MachineUpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public IItemHandler getSidedInventory(@Nullable Direction direction) {
        if (direction == null) {
            direction = Direction.NORTH;
        }
        return switch (direction) {
            case Direction.UP -> this.sidedInventoryWrappers[0];
            case Direction.DOWN -> this.sidedInventoryWrappers[1];
            default -> this.sidedInventoryWrappers[2];
        };
    }

    public static void tick(Level level, BlockPos pos, BlockState state, SoulExtractorTileEntity tile) {
        MachineUpgradeTier tier;
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(1);
            if (tile.fuelLeft <= 0 && !fuel.isEmpty()) {
                tile.fuelItemValue = fuel.getBurnTime(null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(1, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        if ((tier = tile.getMachineTier()) != tile.tier) {
            tile.tier = tier;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        ISoulExtractionRecipe recipe = tile.getActiveRecipe();
        tile.isRunning = false;
        if (recipe != null) {
            if (tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
                tile.isRunning = true;
                ++tile.progress;
                tile.energy.extractEnergy(tile.getFuelUsage(), false);
                if (tile.progress >= tile.getOperationTime()) {
                    tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)tile.inventory.getStackInSlot(0), (int)1, (boolean)false));
                    tile.inventory.setStackInSlot(2, recipe.assemble((RecipeInput)tile.toCraftingInput(), (HolderLookup.Provider)level.registryAccess()));
                    tile.progress = 0;
                }
                tile.setChangedFast();
            }
        } else if (tile.progress > 0) {
            tile.progress = 0;
            tile.setChangedFast();
        }
        if (wasRunning != tile.isRunning) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SoulExtractorBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return SoulExtractorTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)3, (OnContentsChangedFunction)onContentsChanged, builder -> {
            builder.setCanInsert((slot, stack) -> switch (slot) {
                case 1 -> FurnaceBlockEntity.isFuel((ItemStack)stack);
                case 2 -> stack.getItem() instanceof SoulJarItem;
                default -> true;
            });
            builder.setCanExtract(slot -> switch (slot) {
                case 1 -> {
                    if (!FurnaceBlockEntity.isFuel((ItemStack)builder.getStackInSlot(1))) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> {
                    ItemStack stack = builder.getStackInSlot(2);
                    if (stack.getItem() instanceof SoulJarItem && MobSoulUtils.isJarFull(stack)) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            });
        });
    }

    public ISoulExtractionRecipe getActiveRecipe() {
        if (this.level == null) {
            return null;
        }
        return (ISoulExtractionRecipe)this.recipe.checkAndGet((RecipeInput)this.toCraftingInput(), this.level);
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 100;
        }
        return (int)(100.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 40;
        }
        return (int)(40.0 * this.tier.getFuelUsageMultiplier());
    }

    private CraftingInput toCraftingInput() {
        return this.inventory.toShapelessCraftingInput();
    }

    private boolean canInsertStackSided(int slot, ItemStack stack, Direction direction) {
        if (direction == null) {
            return true;
        }
        if (slot == 0 && direction == Direction.UP) {
            return RecipeIngredientCache.INSTANCE.isValidInput(stack, (RecipeType)ModRecipeTypes.SOUL_EXTRACTION.get());
        }
        if (slot == 1 && direction == Direction.NORTH) {
            return FurnaceBlockEntity.isFuel((ItemStack)stack);
        }
        if (slot == 2 && direction == Direction.NORTH) {
            return stack.getItem() instanceof SoulJarItem;
        }
        return false;
    }
}

