/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.inventory.OnContentsChangedFunction;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.tinkering.IAugmentProvider;
import com.blakebr0.mysticalagriculture.api.tinkering.ITinkerable;
import com.blakebr0.mysticalagriculture.container.TinkeringTableContainer;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class TinkeringTableTileEntity
extends BaseInventoryTileEntity
implements MenuProvider {
    private final BaseItemStackHandler inventory = TinkeringTableTileEntity.createInventoryHandler(slot -> this.setChangedAndDispatch());

    public TinkeringTableTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.TINKERING_TABLE.get(), pos, state);
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Localizable.of((String)"container.mysticalagriculture.tinkering_table").build();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return TinkeringTableContainer.create(windowId, playerInventory, (IItemHandlerModifiable)this.inventory, this.getBlockPos());
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return TinkeringTableTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(OnContentsChangedFunction onContentsChanged) {
        return BaseItemStackHandler.create((int)7, (OnContentsChangedFunction)onContentsChanged, builder -> {
            builder.setDefaultSlotLimit(1);
            builder.setCanInsert((slot, stack) -> {
                Item item = stack.getItem();
                return switch (slot) {
                    case 0 -> item instanceof ITinkerable;
                    case 1, 2 -> item instanceof IAugmentProvider;
                    case 3 -> {
                        if (item == ModCrops.AIR.getEssenceItem()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 4 -> {
                        if (item == ModCrops.EARTH.getEssenceItem()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 5 -> {
                        if (item == ModCrops.WATER.getEssenceItem()) {
                            yield true;
                        }
                        yield false;
                    }
                    case 6 -> {
                        if (item == ModCrops.FIRE.getEssenceItem()) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> true;
                };
            });
        });
    }
}

