/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.boards.keys;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.boards.keys.BoardType;

public class PlayerBoardType {
    private final UUID playerId;
    private final String board;
    private final TimedType type;

    public PlayerBoardType(OfflinePlayer player, String board, TimedType type) {
        this.playerId = player.getUniqueId();
        this.board = board;
        this.type = type;
    }

    public OfflinePlayer getPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.playerId);
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getBoard() {
        return this.board;
    }

    public TimedType getType() {
        return this.type;
    }

    public BoardType getBoardType() {
        return new BoardType(this.board, this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PlayerBoardType)) {
            return false;
        }
        PlayerBoardType that = (PlayerBoardType)o;
        return this.getPlayerId().equals(that.getPlayerId()) && this.getBoard().equals(that.getBoard()) && this.getType() == that.getType();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getPlayerId(), this.getBoard(), this.getType()});
    }

    public String toString() {
        return "PlayerBoardType{playerId=" + this.playerId + ", board='" + this.board + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

