/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.base;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public abstract class BaseCommand {
    private String name;
    private final List<SubCommand> subCommands = new ArrayList<SubCommand>();
    private final List<String> aliases;
    private final String permission;
    private final String description;
    boolean showInTabComplete = true;

    public BaseCommand(String name, List<String> aliases, String permission, String description) {
        this.name = name;
        this.aliases = aliases;
        this.permission = permission;
        this.description = description;
    }

    public void setShowInTabComplete(boolean showInTabComplete) {
        this.showInTabComplete = showInTabComplete;
    }

    public String getName() {
        return this.name;
    }

    public ImmutableList<String> getAliases() {
        return ImmutableList.copyOf(this.aliases);
    }

    public ImmutableList<SubCommand> getSubCommands() {
        return ImmutableList.copyOf(this.subCommands);
    }

    public String getPermission() {
        return this.permission;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean showInTabComplete() {
        return this.showInTabComplete;
    }

    public void addSubCommand(SubCommand subCommand) {
        this.subCommands.add(subCommand);
    }

    public boolean checkPermission(CommandSender sender) {
        return this.getPermission() == null || sender.hasPermission(this.getPermission());
    }

    public List<String> filterCompletion(List<String> in, String current) {
        ArrayList<String> out = new ArrayList<String>(in);
        out.removeIf(t -> !t.toLowerCase(Locale.ROOT).contains(current.toLowerCase(Locale.ROOT)));
        return out;
    }

    public List<String> subCommandAutoComplete(CommandSender sender, String[] args) {
        if (args.length > 1) {
            for (SubCommand subCommand : this.subCommands) {
                if (!args[0].equalsIgnoreCase(subCommand.getName()) && !subCommand.getAliases().contains((Object)args[0].toLowerCase(Locale.ROOT)) || !sender.hasPermission(subCommand.getPermission())) continue;
                List<String> subCommandCompleted = subCommand.autoComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                if (subCommandCompleted != null) {
                    subCommandCompleted.removeAll(Collections.singletonList(null));
                }
                return subCommandCompleted;
            }
            return new ArrayList<String>();
        }
        ArrayList<String> commands = new ArrayList<String>();
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.showInTabComplete() || !sender.hasPermission(subCommand.getPermission())) continue;
            commands.add(subCommand.getName());
            if (subCommand.getAliases() == null) continue;
            commands.addAll((Collection<String>)subCommand.getAliases());
        }
        commands.removeAll(Collections.singleton(null));
        return commands;
    }

    public boolean subCommandExecute(CommandSender sender, String[] args, String label) {
        if (args.length < 1) {
            return false;
        }
        for (SubCommand subCommand : this.subCommands) {
            if (!args[0].equalsIgnoreCase(subCommand.getName()) && !subCommand.getAliases().contains((Object)args[0].toLowerCase(Locale.ROOT))) continue;
            subCommand.execute(sender, Arrays.copyOfRange(args, 1, args.length), label);
            return true;
        }
        return false;
    }

    public abstract List<String> autoComplete(CommandSender var1, String[] var2);

    public abstract void execute(CommandSender var1, String[] var2, String var3);
}

