/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.BaseCommand;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;
import us.ajg0702.leaderboards.commands.main.subcommands.Add;
import us.ajg0702.leaderboards.commands.main.subcommands.CheckUpdate;
import us.ajg0702.leaderboards.commands.main.subcommands.Export;
import us.ajg0702.leaderboards.commands.main.subcommands.Import;
import us.ajg0702.leaderboards.commands.main.subcommands.ListCommand;
import us.ajg0702.leaderboards.commands.main.subcommands.Reload;
import us.ajg0702.leaderboards.commands.main.subcommands.Remove;
import us.ajg0702.leaderboards.commands.main.subcommands.RemovePlayer;
import us.ajg0702.leaderboards.commands.main.subcommands.Reset;
import us.ajg0702.leaderboards.commands.main.subcommands.Update;
import us.ajg0702.leaderboards.commands.main.subcommands.UpdateAllOffline;
import us.ajg0702.leaderboards.commands.main.subcommands.UpdatePlayer;
import us.ajg0702.leaderboards.commands.main.subcommands.Version;
import us.ajg0702.leaderboards.commands.main.subcommands.Viewer;
import us.ajg0702.leaderboards.commands.main.subcommands.debug.Format;
import us.ajg0702.leaderboards.commands.main.subcommands.debug.Resets;
import us.ajg0702.leaderboards.commands.main.subcommands.debug.Save;
import us.ajg0702.leaderboards.commands.main.subcommands.debug.Time;
import us.ajg0702.leaderboards.commands.main.subcommands.signs.Signs;

public class MainCommand
extends BaseCommand {
    public MainCommand(LeaderboardPlugin plugin) {
        super("ajleaderboards", Arrays.asList("ajl", "ajlb"), "ajleaderboards.use", "Main comamnd for ajLeaderboards");
        this.addSubCommand(new Version(plugin));
        this.addSubCommand(new Reload(plugin));
        this.addSubCommand(new Add(plugin));
        this.addSubCommand(new CheckUpdate(plugin));
        this.addSubCommand(new UpdatePlayer(plugin));
        this.addSubCommand(new RemovePlayer(plugin));
        this.addSubCommand(new Remove(plugin));
        this.addSubCommand(new ListCommand(plugin));
        this.addSubCommand(new Signs(plugin));
        this.addSubCommand(new Export(plugin));
        this.addSubCommand(new Import(plugin));
        this.addSubCommand(new Viewer(plugin));
        this.addSubCommand(new Reset(plugin));
        this.addSubCommand(new UpdateAllOffline(plugin));
        this.addSubCommand(new Update(plugin));
        this.addSubCommand(new Time());
        this.addSubCommand(new Resets(plugin));
        this.addSubCommand(new Format());
        this.addSubCommand(new Save(plugin));
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        if (!this.checkPermission(sender)) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return this.filterCompletion(this.subCommandAutoComplete(sender, args), args[0]);
        }
        return this.subCommandAutoComplete(sender, args);
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (!this.checkPermission(sender)) {
            sender.sendMessage(LeaderboardPlugin.message("<red>You don't have permission to do this!"));
        }
        if (this.subCommandExecute(sender, args, label)) {
            return;
        }
        MainCommand.sendHelp(sender, label, this.getSubCommands());
    }

    public static void sendHelp(CommandSender sender, String label, List<SubCommand> subCommands) {
        sender.sendMessage(LeaderboardPlugin.message(""));
        for (SubCommand subCommand : subCommands) {
            if (!subCommand.showInTabComplete()) continue;
            String command = "/" + label + " " + subCommand.getName();
            sender.sendMessage(LeaderboardPlugin.message("<hover:show_text:'<yellow>Click to start typing <gold>" + command + "'><click:suggest_command:" + command + " ><gold>" + command + "<yellow> - " + subCommand.getDescription() + "</click></hover>"));
        }
    }
}

