/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class Remove
extends SubCommand {
    private final LeaderboardPlugin plugin;
    final HashMap<Object, String> confirmDeletes = new HashMap();

    public Remove(LeaderboardPlugin plugin) {
        super("remove", Collections.emptyList(), "ajleaderboards.use", "Delete a board and all of its data.");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return this.filterCompletion(this.plugin.getTopManager().getBoards(), args[0]);
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (args.length < 1) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a placeholder to remove.\n&7Usage: /" + label + " remove <board>"));
            return;
        }
        String board = args[0];
        if (!this.plugin.getCache().boardExists(board)) {
            sender.sendMessage(LeaderboardPlugin.message("&cThe board '" + board + "' does not exist."));
            return;
        }
        Debug.info("Confirming: " + this.confirmDeletes.containsKey(sender));
        if (!this.confirmDeletes.containsKey(sender.getHandle()) || this.confirmDeletes.containsKey(sender.getHandle()) && !this.confirmDeletes.get(sender.getHandle()).equals(board)) {
            sender.sendMessage(LeaderboardPlugin.message("&cThis action will delete data! If you add back the board, the top players will have to join again to show up.\n&7Repeat the command within 15 seconds to confirm this action\n&7Or click: <click:run_command:'/ajleaderboards remove " + board + "'><green><b><hover:show_text:'<gray>Click to confirm removing the board\n<red>WARNING: <yellow>This will delete the cache for this leaderboard!'>[CONFIRM]</hover></b></green></click>"));
            this.confirmDeletes.put(sender.getHandle(), board);
            Debug.info("Added confirmDelete: " + this.confirmDeletes.keySet().size());
            this.plugin.getScheduler().runTaskLaterAsynchronously(() -> {
                Debug.info("Removing confirmDelete");
                if (this.confirmDeletes.containsKey(sender.getHandle()) && this.confirmDeletes.get(sender.getHandle()).equals(board)) {
                    this.confirmDeletes.remove(sender.getHandle());
                    Debug.info("Removed confirmDelete");
                }
            }, 300L);
        } else {
            this.confirmDeletes.remove(sender);
            if (this.plugin.getCache().removeBoard(board)) {
                sender.sendMessage(LeaderboardPlugin.message("&aThe board has been removed!"));
            } else {
                sender.sendMessage(LeaderboardPlugin.message("&cSomething went wrong. Check the console for more info."));
            }
        }
    }
}

