/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class RemovePlayer
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public RemovePlayer(LeaderboardPlugin plugin) {
        super("removeplayer", Arrays.asList("rmplayer", "rmpl"), "ajleaderboards.use", "Clear a player from the cache. If they are not excluded from the leaderboard, they will be added next time they are updated.");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] args) {
        if (args.length == 1) {
            return null;
        }
        if (args.length == 2) {
            ArrayList<String> boards = new ArrayList<String>(this.plugin.getTopManager().getBoards());
            boards.add("*");
            return this.filterCompletion(boards, args[1]);
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (args.length < 1) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a board and a player.\n&7Usage: /" + label + " removeplayer <player> <board>"));
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a board.\n&7Usage: /" + label + " removeplayer <player> <board>"));
            return;
        }
        String playername = args[0];
        String board = args[1];
        if (!this.plugin.getCache().boardExists(board) && !"*".equals(board)) {
            sender.sendMessage(LeaderboardPlugin.message("&cThe board '" + board + "' does not exist."));
            return;
        }
        List<String> boards = Collections.singletonList(board);
        if ("*".equals(board)) {
            boards = this.plugin.getCache().getBoards();
        }
        List<String> finalBoards = boards;
        this.plugin.getScheduler().runTaskAsynchronously(() -> {
            for (String b : finalBoards) {
                if (this.plugin.getCache().removePlayer(b, playername)) {
                    sender.sendMessage(LeaderboardPlugin.message("&aRemoved " + playername + " from " + b + "!"));
                    continue;
                }
                sender.sendMessage(LeaderboardPlugin.message("&cUnable to remove " + playername + " from " + b + ". &7Check the console for more info."));
            }
            if ("*".equals(board)) {
                sender.sendMessage(LeaderboardPlugin.message("&aFinished removing " + playername + " from all boards!"));
            }
        });
    }
}

