/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;
import us.ajg0702.leaderboards.libs.utils.common.UpdateManager;

public class Update
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Update(LeaderboardPlugin plugin) {
        super("update", Collections.singletonList("updateplugin"), "ajLeaderboards.use", "Download an update for ajLeaderboards (if it is available)");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] strings) {
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender commandSender, String[] strings, String s) {
        UpdateManager updater = this.plugin.getUpdateManager();
        if (updater == null) {
            commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.disabled", new String[0]));
            return;
        }
        AtomicBoolean done = new AtomicBoolean(false);
        this.plugin.getScheduler().runTaskAsynchronously(() -> {
            try {
                UpdateManager.DownloadCompleteStatus result = updater.downloadUpdate();
                done.set(true);
                switch (result) {
                    case SUCCESS: {
                        commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.success", new String[0]));
                        break;
                    }
                    case WARNING_COULD_NOT_DELETE_OLD_JAR: {
                        commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.warnings.could-not-delete-old-jar", new String[0]));
                        break;
                    }
                    case ERROR_NO_UPDATE_AVAILABLE: {
                        commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.errors.no-update-available", new String[0]));
                        break;
                    }
                    case ERROR_WHILE_CHECKING: {
                        commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.errors.while-checking", new String[0]));
                        break;
                    }
                    case ERROR_ALREADY_DOWNLOADED: {
                        commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.errors.already-downloaded", new String[0]));
                        break;
                    }
                    case ERROR_WHILE_DOWNLOADING: {
                        commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.errors.while-downloading", new String[0]));
                        break;
                    }
                    default: {
                        commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.errors.unknown", "ERROR:" + (Object)((Object)result)));
                        break;
                    }
                }
            }
            catch (Exception e) {
                commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.errors.uncaught", new String[0]));
            }
        });
        this.plugin.getScheduler().runTaskLaterAsynchronously(() -> {
            if (done.get()) {
                return;
            }
            commandSender.sendMessage(this.plugin.getMessages().getComponent("updater.slow-feedback", new String[0]));
        }, 20L);
    }
}

