/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands.debug;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.Component;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.TextComponent;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.format.NamedTextColor;

public class Resets
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public Resets(LeaderboardPlugin plugin) {
        super("resets", Collections.emptyList(), null, "Show reset times");
        this.setShowInTabComplete(false);
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return this.filterCompletion(this.plugin.getTopManager().getBoards(), args[0]);
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (args.length == 0) {
            sender.sendMessage(Component.text("Need board name!").color(NamedTextColor.RED));
            return;
        }
        String board = args[0];
        if (!this.plugin.getTopManager().boardExists(board)) {
            sender.sendMessage(Component.text("Invalid board").color(NamedTextColor.RED));
            return;
        }
        for (TimedType type : TimedType.values()) {
            if (type == TimedType.ALLTIME) continue;
            sender.sendMessage(Component.text(type.toString()).color(NamedTextColor.YELLOW));
            sender.sendMessage(((TextComponent)Component.text("  Next: ").color(NamedTextColor.GOLD)).append(Component.text(this.formatTime(type.getNextReset())).color(NamedTextColor.YELLOW)));
            sender.sendMessage(((TextComponent)Component.text("  Last: ").color(NamedTextColor.GOLD)).append(Component.text(this.formatTime(LocalDateTime.ofEpochSecond(this.plugin.getTopManager().getLastReset(board, type), 0, ZoneOffset.UTC))).color(NamedTextColor.YELLOW)));
            sender.sendMessage(((TextComponent)Component.text("  Est. last: ").color(NamedTextColor.GOLD)).append(Component.text(this.formatTime(type.getEstimatedLastReset())).color(NamedTextColor.YELLOW)));
        }
    }

    private String formatTime(LocalDateTime time) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(time.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME).split(" ")));
        parts.remove(parts.size() - 1);
        return String.join((CharSequence)" ", parts);
    }
}

