/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.downloader;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import us.ajg0702.leaderboards.libs.slimjar.downloader.DependencyDownloader;
import us.ajg0702.leaderboards.libs.slimjar.downloader.output.OutputWriter;
import us.ajg0702.leaderboards.libs.slimjar.downloader.output.OutputWriterFactory;
import us.ajg0702.leaderboards.libs.slimjar.downloader.verify.DependencyVerifier;
import us.ajg0702.leaderboards.libs.slimjar.logging.LogDispatcher;
import us.ajg0702.leaderboards.libs.slimjar.logging.ProcessLogger;
import us.ajg0702.leaderboards.libs.slimjar.resolver.DependencyResolver;
import us.ajg0702.leaderboards.libs.slimjar.resolver.ResolutionResult;
import us.ajg0702.leaderboards.libs.slimjar.resolver.UnresolvedDependencyException;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;
import us.ajg0702.leaderboards.libs.slimjar.util.Connections;

public final class URLDependencyDownloader
implements DependencyDownloader {
    private static final byte[] BOM_BYTES = "bom-file".getBytes();
    private static final ProcessLogger LOGGER = LogDispatcher.getMediatingLogger();
    private final OutputWriterFactory outputWriterProducer;
    private final DependencyResolver dependencyResolver;
    private final DependencyVerifier verifier;

    public URLDependencyDownloader(OutputWriterFactory outputWriterProducer, DependencyResolver dependencyResolver, DependencyVerifier verifier) {
        this.outputWriterProducer = outputWriterProducer;
        this.dependencyResolver = dependencyResolver;
        this.verifier = verifier;
    }

    @Override
    public File download(Dependency dependency) throws IOException {
        File expectedOutputFile = this.outputWriterProducer.getStrategy().selectFileFor(dependency);
        if (expectedOutputFile.exists() && expectedOutputFile.length() == (long)BOM_BYTES.length && Arrays.equals(Files.readAllBytes(expectedOutputFile.toPath()), BOM_BYTES)) {
            return null;
        }
        if (this.verifier.verify(expectedOutputFile, dependency)) {
            return expectedOutputFile;
        }
        ResolutionResult result = this.dependencyResolver.resolve(dependency).orElseThrow(() -> new UnresolvedDependencyException(dependency));
        if (result.isAggregator()) {
            expectedOutputFile.getParentFile().mkdirs();
            expectedOutputFile.createNewFile();
            Files.write(expectedOutputFile.toPath(), BOM_BYTES, new OpenOption[0]);
            return null;
        }
        expectedOutputFile.delete();
        File checksumFile = this.verifier.getChecksumFile(dependency);
        if (checksumFile != null) {
            checksumFile.delete();
        }
        LOGGER.log("Downloading {0}...", dependency.getArtifactId());
        URL url = result.getDependencyURL();
        LOGGER.debug("Connecting to {0}", url);
        URLConnection connection = Connections.createDownloadConnection(url);
        InputStream inputStream = connection.getInputStream();
        LOGGER.debug("Connection successful! Downloading {0}", dependency.getArtifactId() + "...");
        OutputWriter outputWriter = this.outputWriterProducer.create(dependency);
        LOGGER.debug("{0}.Size = {1}", dependency.getArtifactId(), connection.getContentLength());
        File downloadResult = outputWriter.writeFrom(inputStream, connection.getContentLength());
        Connections.tryDisconnect(connection);
        this.verifier.verify(downloadResult, dependency);
        LOGGER.debug("Artifact {0} downloaded successfully!", dependency.getArtifactId());
        LOGGER.log("Downloaded {0} successfully!", dependency.getArtifactId());
        return downloadResult;
    }
}

