/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.downloader.verify;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.ajg0702.leaderboards.libs.slimjar.downloader.verify.ChecksumCalculator;

public final class FileChecksumCalculator
implements ChecksumCalculator {
    private static final String DIRECTORY_HASH = "DIRECTORY";
    private static final Logger LOGGER = Logger.getLogger(FileChecksumCalculator.class.getName());
    private final MessageDigest digest;

    public FileChecksumCalculator(String algorithm) throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance(algorithm);
    }

    @Override
    public String calculate(File file) throws IOException {
        LOGGER.log(Level.FINEST, "Calculating hash for {0}", file.getPath());
        if (file.isDirectory()) {
            return DIRECTORY_HASH;
        }
        this.digest.reset();
        try (FileInputStream fis = new FileInputStream(file);){
            int bytesCount;
            byte[] byteArray = new byte[1024];
            while ((bytesCount = fis.read(byteArray)) != -1) {
                this.digest.update(byteArray, 0, bytesCount);
            }
        }
        byte[] bytes = this.digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toString((b & 0xFF) + 256, 16).substring(1));
        }
        sb.trimToSize();
        String result = sb.toString();
        LOGGER.log(Level.FINEST, "Hash for {0} -> {1}", new Object[]{file.getPath(), result});
        return result;
    }
}

