/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.resolver.mirrors;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Mirror;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;
import us.ajg0702.leaderboards.libs.slimjar.resolver.mirrors.MirrorSelector;

public final class SimpleMirrorSelector
implements MirrorSelector {
    public static final String CENTRAL_URL = "https://repo.maven.apache.org/maven2/";
    public static final String ALT_CENTRAL_URL = "https://repo1.maven.org/maven2/";
    public static final String DEFAULT_CENTRAL_MIRROR_URL = "https://repo1.maven.org/maven2/";
    private static final Collection<String> CENTRAL_REPO = Arrays.asList("https://repo.maven.apache.org/maven2/", "https://repo1.maven.org/maven2/");
    private final Collection<Repository> centralMirrors;

    public SimpleMirrorSelector(Collection<Repository> centralMirrors) {
        this.centralMirrors = centralMirrors;
    }

    @Override
    public Collection<Repository> select(Collection<Repository> mainRepositories, Collection<Mirror> mirrors) throws MalformedURLException {
        Collection originals = mirrors.stream().map(Mirror::getOriginal).collect(Collectors.toSet());
        Collection resolved = mainRepositories.stream().filter(repo -> !originals.contains(repo.getUrl())).filter(repo -> !SimpleMirrorSelector.isCentral(repo)).collect(Collectors.toSet());
        Collection mirrored = mirrors.stream().map(Mirror::getMirroring).map(Repository::new).collect(Collectors.toSet());
        resolved.addAll(mirrored);
        resolved.addAll(this.centralMirrors);
        return resolved;
    }

    private static boolean isCentral(Repository repository) {
        String url = repository.getUrl().toString();
        return CENTRAL_REPO.contains(url);
    }
}

