/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.resolver.strategy;

import java.util.Arrays;
import java.util.Collection;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;
import us.ajg0702.leaderboards.libs.slimjar.resolver.strategy.PathResolutionStrategy;
import us.ajg0702.leaderboards.libs.slimjar.util.Repositories;

public final class MavenSnapshotPathResolutionStrategy
implements PathResolutionStrategy {
    private static final String PATH_FORMAT_ALT = "%s%s/%s/%s-SNAPSHOT/%4$s-%s/%3$s-%4$s-%5$s.jar";
    private static final String PATH_FORMAT = "%s%s/%s/%s-SNAPSHOT/%3$s-%4$s-%5$s.jar";

    @Override
    public Collection<String> pathTo(Repository repository, Dependency dependency) {
        String repoUrl = Repositories.fetchFormattedUrl(repository);
        String version = dependency.getVersion().replace("-SNAPSHOT", "");
        String alt = String.format(PATH_FORMAT_ALT, repoUrl, dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), version, dependency.getSnapshotId());
        String general = String.format(PATH_FORMAT, repoUrl, dependency.getGroupId().replace('.', '/'), dependency.getArtifactId(), version, dependency.getSnapshotId());
        return Arrays.asList(general, alt);
    }
}

