/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.utils;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.entity.Player;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.cache.helpers.DbRow;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.Nullable;
import us.ajg0702.leaderboards.libs.kyori.adventure.audience.Audience;

public class Exporter {
    private final LeaderboardPlugin plugin;

    public Exporter(LeaderboardPlugin plugin) {
        this.plugin = plugin;
    }

    public JsonObject export(@Nullable Audience reportTo) {
        return this.export(reportTo, null);
    }

    public JsonObject export(@Nullable Audience reportTo, @Nullable List<String> boards) {
        if (reportTo != null) {
            reportTo.sendMessage(this.plugin.getMessages().getComponent("commands.export.starting", new String[0]));
        }
        String takerUUID = "f78a4d8d-d51b-4b39-98a3-230f2de0c670";
        String takerName = "Console";
        if (reportTo instanceof CommandSender && ((CommandSender)reportTo).isPlayer()) {
            Player taker = (Player)((CommandSender)reportTo).getHandle();
            takerUUID = taker.getUniqueId().toString();
            takerName = taker.getName();
        }
        this.plugin.getLogger().info("Starting export");
        HashMap<String, List<DbRow>> rows = new HashMap<String, List<DbRow>>();
        int i = 0;
        List<String> allBoards = boards == null ? this.plugin.getCache().getBoards() : boards;
        for (String board : allBoards) {
            try {
                DbRow.clearPositionCache();
                rows.put(board, this.plugin.getCache().getRows(board));
                if (reportTo != null) {
                    reportTo.sendMessage(this.plugin.getMessages().getComponent("commands.export.progress", "DONE:" + ++i, "TOTAL:" + allBoards.size()));
                }
                this.plugin.getLogger().info(String.format("Export progress: %d/%d fetched", i, allBoards.size()));
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "An error occurred while fetching rows from the database:", e);
                return null;
            }
        }
        JsonObject obj = new JsonObject();
        for (Map.Entry entry : rows.entrySet()) {
            JsonArray elements = new JsonArray();
            ((List)entry.getValue()).forEach(t -> elements.add((JsonElement)t.toJsonObject()));
            obj.add((String)entry.getKey(), (JsonElement)elements);
        }
        obj.add("meta", (JsonElement)new Gson().fromJson("{\"version\": \"" + this.plugin.getDescription().getVersion() + "\", \"datestamp\": " + System.currentTimeMillis() + ", \"taker\": {\"uuid\": \"" + takerUUID + "\",\"name\": \"" + takerName + "\"}}", JsonObject.class));
        return obj;
    }
}

