/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.utils;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import javax.annotation.Nullable;
import org.bukkit.OfflinePlayer;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;

public class OfflineUpdater {
    private final Deque<OfflinePlayer> offlinePlayerQueue = new ArrayDeque<OfflinePlayer>();
    private final LeaderboardPlugin plugin;
    private final CommandSender reportTo;
    private final int started;
    private final String board;
    private long startedTime;

    public OfflineUpdater(LeaderboardPlugin plugin, String board, OfflinePlayer[] players, @Nullable CommandSender reportTo) {
        this.plugin = plugin;
        this.board = board;
        this.reportTo = reportTo;
        this.offlinePlayerQueue.addAll(Arrays.asList(players));
        this.started = this.offlinePlayerQueue.size();
        plugin.getScheduler().runTaskAsynchronously(() -> {
            this.startedTime = System.currentTimeMillis();
            while (!this.offlinePlayerQueue.isEmpty() && !plugin.isShuttingDown()) {
                OfflinePlayer player = this.offlinePlayerQueue.pop();
                plugin.getCache().updateStat(board, player);
            }
            if (plugin.isShuttingDown()) {
                plugin.getLogger().info("[OfflineUpdater] " + board + ": Canceling due to plugin shutdown");
            } else {
                long duration = System.currentTimeMillis() - this.startedTime;
                double durationSeconds = (double)Math.round((double)duration / 10.0) / 100.0;
                plugin.getLogger().info("[OfflineUpdater] " + board + ": Finished in " + durationSeconds + "s " + duration);
                if (reportTo != null) {
                    reportTo.sendMessage(LeaderboardPlugin.message("&aFinished updating all offline players for &f" + board + " &ain&f " + durationSeconds + "&as"));
                }
            }
            plugin.getOfflineUpdaters().remove(board, this);
        });
    }

    public double getProgressPercent() {
        return (double)this.offlinePlayerQueue.size() / (double)this.started;
    }

    public int getRemainingPlayers() {
        return this.offlinePlayerQueue.size();
    }

    public int getDonePlayers() {
        return this.started - this.offlinePlayerQueue.size();
    }

    public int getStarted() {
        return this.started;
    }

    public boolean isDone() {
        return this.getRemainingPlayers() == 0;
    }

    public void progressLog() {
        this.plugin.getLogger().info("[OfflineUpdater] " + this.board + ": " + Math.round(this.getProgressPercent() * 1000.0) / 10L + "% done (" + this.getRemainingPlayers() + " / " + this.getStarted() + ")");
    }
}

