/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.boards;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.OfflinePlayer;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.boards.keys.BoardType;
import us.ajg0702.leaderboards.boards.keys.ExtraKey;
import us.ajg0702.leaderboards.boards.keys.PlayerBoardType;
import us.ajg0702.leaderboards.boards.keys.PositionBoardType;
import us.ajg0702.leaderboards.cache.BlockingFetch;
import us.ajg0702.leaderboards.cache.CacheMethod;
import us.ajg0702.leaderboards.cache.methods.MysqlMethod;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.NotNull;
import us.ajg0702.leaderboards.nms.legacy.ThreadFactoryProxy;
import us.ajg0702.leaderboards.utils.Cached;

public class TopManager {
    private final ThreadPoolExecutor fetchService;
    private final AtomicInteger fetching = new AtomicInteger(0);
    private static final String OUT_OF_THREADS_MESSAGE = "unable to create native thread: possibly out of memory or process/resource limits reached";
    private final LeaderboardPlugin plugin;
    Map<PositionBoardType, Long> positionLastRefresh = new HashMap<PositionBoardType, Long>();
    List<PositionBoardType> positionFetching = new CopyOnWriteArrayList<PositionBoardType>();
    LoadingCache<PositionBoardType, StatEntry> positionCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).refreshAfterWrite(5L, TimeUnit.SECONDS).maximumSize(10000L).removalListener(notification -> {
        if (!notification.getCause().equals((Object)RemovalCause.REPLACED)) {
            this.positionLastRefresh.remove((PositionBoardType)notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<PositionBoardType, StatEntry>(){

        @NotNull
        public StatEntry load(@NotNull PositionBoardType key) {
            return TopManager.this.plugin.getCache().getStat(key.getPosition(), key.getBoard(), key.getType());
        }

        @NotNull
        public ListenableFuture<StatEntry> reload(@NotNull PositionBoardType key, @NotNull StatEntry oldValue) {
            if (TopManager.this.plugin.isShuttingDown() || System.currentTimeMillis() - TopManager.this.positionLastRefresh.getOrDefault(key, 0L) < (long)TopManager.this.cacheTime()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                TopManager.this.positionLastRefresh.put(key, System.currentTimeMillis());
                return TopManager.this.plugin.getCache().getStat(key.getPosition(), key.getBoard(), key.getType());
            });
            if (TopManager.this.plugin.isShuttingDown()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            TopManager.this.fetchService.execute((Runnable)task);
            return task;
        }
    });
    public final Map<UUID, Map<BoardType, Integer>> positionPlayerCache = new ConcurrentHashMap<UUID, Map<BoardType, Integer>>();
    Map<PlayerBoardType, Long> statEntryLastRefresh = new HashMap<PlayerBoardType, Long>();
    LoadingCache<PlayerBoardType, StatEntry> statEntryCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).refreshAfterWrite(1L, TimeUnit.SECONDS).maximumSize(10000L).removalListener(notification -> {
        if (!notification.getCause().equals((Object)RemovalCause.REPLACED)) {
            this.statEntryLastRefresh.remove((PlayerBoardType)notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<PlayerBoardType, StatEntry>(){

        @NotNull
        public StatEntry load(@NotNull PlayerBoardType key) {
            return TopManager.this.plugin.getCache().getStatEntry(key.getPlayer(), key.getBoard(), key.getType());
        }

        @NotNull
        public ListenableFuture<StatEntry> reload(@NotNull PlayerBoardType key, @NotNull StatEntry oldValue) {
            long msSinceRefresh = System.currentTimeMillis() - TopManager.this.statEntryLastRefresh.getOrDefault(key, 0L);
            double cacheTime = Math.max((double)TopManager.this.cacheTime() * 1.5, (double)TopManager.this.plugin.getAConfig().getInt("min-player-cache-time").intValue());
            if (TopManager.this.plugin.isShuttingDown() || (double)msSinceRefresh < cacheTime + cacheTime / 2.0 * Math.random()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                TopManager.this.statEntryLastRefresh.put(key, System.currentTimeMillis());
                return TopManager.this.plugin.getCache().getStatEntry(key.getPlayer(), key.getBoard(), key.getType());
            });
            if (TopManager.this.plugin.isShuttingDown()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            TopManager.this.fetchService.execute((Runnable)task);
            return task;
        }
    });
    Map<String, Long> boardSizeLastRefresh = new HashMap<String, Long>();
    LoadingCache<String, Integer> boardSizeCache = CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).refreshAfterWrite(1L, TimeUnit.SECONDS).maximumSize(10000L).removalListener(notification -> {
        if (!notification.getCause().equals((Object)RemovalCause.REPLACED)) {
            this.boardSizeLastRefresh.remove((String)notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<String, Integer>(){

        @NotNull
        public Integer load(@NotNull String key) {
            return TopManager.this.plugin.getCache().getBoardSize(key);
        }

        @NotNull
        public ListenableFuture<Integer> reload(@NotNull String key, @NotNull Integer oldValue) {
            if (TopManager.this.plugin.isShuttingDown() || System.currentTimeMillis() - TopManager.this.boardSizeLastRefresh.getOrDefault(key, 0L) < (long)Math.max(TopManager.this.cacheTime() * 2, 5000)) {
                return Futures.immediateFuture((Object)oldValue);
            }
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                TopManager.this.boardSizeLastRefresh.put(key, System.currentTimeMillis());
                return TopManager.this.plugin.getCache().getBoardSize(key);
            });
            if (TopManager.this.plugin.isShuttingDown()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            TopManager.this.fetchService.execute((Runnable)task);
            return task;
        }
    });
    Map<BoardType, Long> totalLastRefresh = new HashMap<BoardType, Long>();
    LoadingCache<BoardType, Double> totalCache = CacheBuilder.newBuilder().expireAfterAccess(24L, TimeUnit.HOURS).refreshAfterWrite(1L, TimeUnit.SECONDS).maximumSize(10000L).removalListener(notification -> {
        if (!notification.getCause().equals((Object)RemovalCause.REPLACED)) {
            this.totalLastRefresh.remove((BoardType)notification.getKey());
        }
    }).build((CacheLoader)new CacheLoader<BoardType, Double>(){

        @NotNull
        public Double load(@NotNull BoardType key) {
            return TopManager.this.plugin.getCache().getTotal(key.getBoard(), key.getType());
        }

        @NotNull
        public ListenableFuture<Double> reload(@NotNull BoardType key, @NotNull Double oldValue) {
            if (TopManager.this.plugin.isShuttingDown() || System.currentTimeMillis() - TopManager.this.totalLastRefresh.getOrDefault(key, 0L) < (long)Math.max(TopManager.this.cacheTime() * 2, 5000)) {
                return Futures.immediateFuture((Object)oldValue);
            }
            ListenableFutureTask task = ListenableFutureTask.create(() -> {
                TopManager.this.totalLastRefresh.put(key, System.currentTimeMillis());
                return TopManager.this.plugin.getCache().getTotal(key.getBoard(), key.getType());
            });
            if (TopManager.this.plugin.isShuttingDown()) {
                return Futures.immediateFuture((Object)oldValue);
            }
            TopManager.this.fetchService.execute((Runnable)task);
            return task;
        }
    });
    List<String> boardCache;
    long lastGetBoard = 0L;
    List<Integer> rolling = new CopyOnWriteArrayList<Integer>();
    LoadingCache<BoardType, Long> lastResetCache = CacheBuilder.newBuilder().expireAfterAccess(12L, TimeUnit.HOURS).refreshAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<BoardType, Long>(){

        @NotNull
        public Long load(@NotNull BoardType key) {
            long start = System.nanoTime();
            long lastReset = TopManager.this.plugin.getCache().getLastReset(key.getBoard(), key.getType()) / 1000L;
            long took = System.nanoTime() - start;
            long tookms = took / 1000000L;
            if (tookms > 500L) {
                Debug.info("lastReset fetch took " + tookms + "ms");
            }
            return lastReset;
        }
    });
    Map<ExtraKey, Cached<String>> extraCache = new HashMap<ExtraKey, Cached<String>>();
    long lastLargeAverage = 0L;

    public void shutdown() {
        this.fetchService.shutdownNow();
    }

    public TopManager(LeaderboardPlugin pl, List<String> initialBoards) {
        this.plugin = pl;
        CacheMethod method = this.plugin.getCache().getMethod();
        int t = method instanceof MysqlMethod ? Math.max(10, method.getMaxConnections()) : this.plugin.getAConfig().getInt("max-fetching-threads");
        int keepAlive = this.plugin.getAConfig().getInt("fetching-thread-pool-keep-alive");
        this.fetchService = new ThreadPoolExecutor(t, t, (long)keepAlive, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000000, true), ThreadFactoryProxy.getDefaultThreadFactory("AJLBFETCH"));
        this.fetchService.allowCoreThreadTimeOut(true);
        this.plugin.getScheduler().runTaskTimerAsynchronously(() -> {
            this.rolling.add(this.getQueuedTasks() + this.getActiveFetchers());
            if (this.rolling.size() > 50) {
                this.rolling.remove(0);
            }
        }, 0L, 2L);
        this.boardCache = initialBoards;
    }

    public StatEntry getStat(int position, String board, TimedType type) {
        StatEntry cached;
        block7: {
            PositionBoardType key = new PositionBoardType(position, board, type);
            try {
                cached = (StatEntry)this.positionCache.getIfPresent((Object)key);
                if (cached != null) break block7;
                if (BlockingFetch.shouldBlock(this.plugin)) {
                    cached = (StatEntry)this.positionCache.getUnchecked((Object)key);
                    break block7;
                }
                if (!this.positionFetching.contains(key)) {
                    if (this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
                        Debug.info("Starting fetch on " + key);
                    }
                    this.positionFetching.add(key);
                    this.fetchService.submit(() -> {
                        this.positionCache.getUnchecked((Object)key);
                        this.positionFetching.remove(key);
                        if (this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
                            Debug.info("Fetch finished on " + key);
                        }
                    });
                }
                if (this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
                    Debug.info("Returning loading for " + key);
                }
                this.cacheStatPosition(position, new BoardType(board, type), null);
                return StatEntry.loading(this.plugin, position, board, type);
            }
            catch (Exception e) {
                if (e.getMessage().contains(OUT_OF_THREADS_MESSAGE)) {
                    this.informAboutThreadLimit();
                    return StatEntry.error(position, board, type);
                }
                throw e;
            }
        }
        this.cacheStatPosition(position, new BoardType(board, type), cached.playerID);
        return cached;
    }

    private void cacheStatPosition(int position, BoardType boardType, UUID playerUUID) {
        for (Map.Entry<UUID, Map<BoardType, Integer>> entry : this.positionPlayerCache.entrySet()) {
            if (entry.getKey().equals(playerUUID)) continue;
            entry.getValue().remove(boardType, position);
        }
        if (playerUUID == null) {
            return;
        }
        Map newMap = this.positionPlayerCache.getOrDefault(playerUUID, new HashMap());
        newMap.put(boardType, position);
        this.positionPlayerCache.put(playerUUID, newMap);
    }

    public StatEntry getStatEntry(OfflinePlayer player, String board, TimedType type) {
        PlayerBoardType key = new PlayerBoardType(player, board, type);
        try {
            StatEntry cached = (StatEntry)this.statEntryCache.getIfPresent((Object)key);
            if (cached == null) {
                if (BlockingFetch.shouldBlock(this.plugin)) {
                    cached = (StatEntry)this.statEntryCache.getUnchecked((Object)key);
                } else {
                    this.fetchService.submit(() -> (StatEntry)this.statEntryCache.getUnchecked((Object)key));
                    return StatEntry.loading(player, key.getBoardType());
                }
            }
            return cached;
        }
        catch (Exception e) {
            if (e.getMessage().contains(OUT_OF_THREADS_MESSAGE)) {
                this.informAboutThreadLimit();
                return StatEntry.error(-4, board, type);
            }
            throw e;
        }
    }

    public StatEntry getCachedStatEntry(OfflinePlayer player, String board, TimedType type) {
        return this.getCachedStatEntry(player, board, type, true);
    }

    public StatEntry getCachedStatEntry(OfflinePlayer player, String board, TimedType type, boolean fetchIfAbsent) {
        StatEntry r;
        PlayerBoardType key = new PlayerBoardType(player, board, type);
        try {
            r = (StatEntry)this.statEntryCache.getIfPresent((Object)key);
            if (fetchIfAbsent && r == null) {
                this.fetchService.submit(() -> (StatEntry)this.statEntryCache.getUnchecked((Object)key));
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains(OUT_OF_THREADS_MESSAGE)) {
                this.informAboutThreadLimit();
                return StatEntry.error(-4, board, type);
            }
            throw e;
        }
        return r;
    }

    public StatEntry getCachedStat(int position, String board, TimedType type) {
        return this.getCachedStat(new PositionBoardType(position, board, type), true);
    }

    public StatEntry getCachedStat(PositionBoardType positionBoardType, boolean fetchIfAbsent) {
        StatEntry r;
        try {
            r = (StatEntry)this.positionCache.getIfPresent((Object)positionBoardType);
            if (r == null && fetchIfAbsent) {
                this.fetchService.submit(() -> (StatEntry)this.positionCache.getUnchecked((Object)positionBoardType));
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains(OUT_OF_THREADS_MESSAGE)) {
                this.informAboutThreadLimit();
                return StatEntry.error(positionBoardType.getPosition(), positionBoardType.getBoard(), positionBoardType.getType());
            }
            throw e;
        }
        return r;
    }

    public int getBoardSize(String board) {
        try {
            Integer cached = (Integer)this.boardSizeCache.getIfPresent((Object)board);
            if (cached == null) {
                if (BlockingFetch.shouldBlock(this.plugin)) {
                    cached = (Integer)this.boardSizeCache.getUnchecked((Object)board);
                } else {
                    this.fetchService.submit(() -> (Integer)this.boardSizeCache.getUnchecked((Object)board));
                    return -2;
                }
            }
            return cached;
        }
        catch (Exception e) {
            if (e.getMessage().contains(OUT_OF_THREADS_MESSAGE)) {
                this.informAboutThreadLimit();
                return -4;
            }
            throw e;
        }
    }

    public double getTotal(String board, TimedType type) {
        BoardType boardType = new BoardType(board, type);
        try {
            Double cached = (Double)this.totalCache.getIfPresent((Object)boardType);
            if (cached == null) {
                if (BlockingFetch.shouldBlock(this.plugin)) {
                    cached = (Double)this.totalCache.getUnchecked((Object)boardType);
                } else {
                    this.fetchService.submit(() -> (Double)this.totalCache.getUnchecked((Object)boardType));
                    return -2.0;
                }
            }
            return cached;
        }
        catch (Exception e) {
            if (e.getMessage().contains(OUT_OF_THREADS_MESSAGE)) {
                this.informAboutThreadLimit();
                return -4.0;
            }
            throw e;
        }
    }

    public List<String> getBoards() {
        if (this.boardCache == null) {
            if (BlockingFetch.shouldBlock(this.plugin)) {
                return this.fetchBoards();
            }
            if (this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
                Debug.info("need to fetch boards");
            }
            this.fetchBoardsAsync();
            this.lastGetBoard = System.currentTimeMillis();
            return new ArrayList<String>();
        }
        if (System.currentTimeMillis() - this.lastGetBoard > (long)this.cacheTime()) {
            this.lastGetBoard = System.currentTimeMillis();
            this.fetchBoardsAsync();
        }
        return this.boardCache;
    }

    public void fetchBoardsAsync() {
        this.checkWrong();
        this.fetchService.submit(this::fetchBoards);
    }

    public List<String> fetchBoards() {
        int f = this.fetching.getAndIncrement();
        if (this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
            Debug.info("Fetching (" + this.fetchService.getPoolSize() + ") (boards): " + f);
        }
        this.boardCache = this.plugin.getCache().getBoards();
        if (this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
            Debug.info("Finished fetching boards");
        }
        this.removeFetching();
        return this.boardCache;
    }

    private void removeFetching() {
        this.fetching.decrementAndGet();
    }

    public int getFetching() {
        return this.fetching.get();
    }

    public int getFetchingAverage() {
        Integer n;
        ArrayList<Integer> snap = new ArrayList<Integer>(this.rolling);
        if (snap.size() == 0) {
            return 0;
        }
        int sum = 0;
        Iterator iterator = snap.iterator();
        while (iterator.hasNext() && (n = (Integer)iterator.next()) != null) {
            sum += n.intValue();
        }
        return sum / snap.size();
    }

    public long getLastReset(String board, TimedType type) {
        return (Long)this.lastResetCache.getUnchecked((Object)new BoardType(board, type));
    }

    public String getExtra(UUID id, String placeholder) {
        ExtraKey key = new ExtraKey(id, placeholder);
        Cached<String> cached = this.extraCache.get(key);
        if (cached == null) {
            if (BlockingFetch.shouldBlock(this.plugin)) {
                return this.fetchExtra(id, placeholder);
            }
            this.extraCache.put(key, new Cached<String>(System.currentTimeMillis(), this.plugin.getMessages().getRawString("loading.text", new String[0])));
            this.fetchExtraAsync(id, placeholder);
            return this.plugin.getMessages().getRawString("loading.text", new String[0]);
        }
        if (System.currentTimeMillis() - cached.getLastGet() > (long)this.cacheTime()) {
            cached.setLastGet(System.currentTimeMillis());
            this.fetchExtraAsync(id, placeholder);
        }
        return cached.getThing();
    }

    public String fetchExtra(UUID id, String placeholder) {
        String value = this.plugin.getExtraManager().getExtra(id, placeholder);
        this.extraCache.put(new ExtraKey(id, placeholder), new Cached<String>(System.currentTimeMillis(), value));
        return value;
    }

    public void fetchExtraAsync(UUID id, String placeholder) {
        this.fetchService.submit(() -> this.fetchExtra(id, placeholder));
    }

    public String getCachedExtra(UUID id, String placeholder) {
        Cached<String> r = this.extraCache.get(new ExtraKey(id, placeholder));
        if (r == null) {
            this.fetchExtraAsync(id, placeholder);
            return null;
        }
        return r.getThing();
    }

    public StatEntry getRelative(OfflinePlayer player, int difference, String board, TimedType type) {
        StatEntry playerStatEntry = this.getCachedStatEntry(player, board, type);
        if (playerStatEntry == null || !playerStatEntry.hasPlayer()) {
            return StatEntry.loading(this.plugin, board, type);
        }
        int position = playerStatEntry.getPosition() + difference;
        if (position < 1) {
            return StatEntry.noRelData(this.plugin, position, board, type);
        }
        return this.getStat(position, board, type);
    }

    private void checkWrong() {
        if (this.fetching.get() > 5000) {
            this.plugin.getLogger().warning("Something might be going wrong, printing some useful info");
            Thread.dumpStack();
        }
    }

    public int cacheTime() {
        boolean recentLargeAverage = System.currentTimeMillis() - this.lastLargeAverage < 30000L;
        boolean moreFetching = this.plugin.getAConfig().getBoolean("more-fetching");
        int r = moreFetching ? (recentLargeAverage ? 5000 : 1000) : 20000;
        int fetchingAverage = this.getFetchingAverage();
        if (fetchingAverage == Integer.MAX_VALUE) {
            return r;
        }
        int activeFetchers = this.getActiveFetchers();
        int totalTasks = activeFetchers + this.getQueuedTasks();
        if (moreFetching) {
            if (!recentLargeAverage) {
                if (fetchingAverage == 0 && activeFetchers == 0) {
                    return 500;
                }
                if (fetchingAverage > 0) {
                    r = 2000;
                }
                if (fetchingAverage >= 2) {
                    r = 5000;
                }
            }
            if ((fetchingAverage >= 5 || totalTasks > 25) && activeFetchers > 0) {
                r = 10000;
            }
            if ((fetchingAverage > 10 || totalTasks > 59) && activeFetchers > 0) {
                r = 15000;
            }
        }
        if ((fetchingAverage > 20 || totalTasks > 75) && activeFetchers > 0) {
            r = 30000;
        }
        if ((fetchingAverage > 30 || totalTasks > 100) && activeFetchers > 0) {
            r = 60000;
        }
        if (fetchingAverage > 50 || totalTasks > 125) {
            this.lastLargeAverage = System.currentTimeMillis();
            if (activeFetchers > 0) {
                r = 120000;
            }
        }
        if ((fetchingAverage > 100 || totalTasks > 150) && activeFetchers > 0) {
            r = 180000;
        }
        if ((fetchingAverage > 300 || totalTasks > 175) && activeFetchers > 0) {
            r = 3600000;
        }
        if ((fetchingAverage > 400 || totalTasks > 200) && activeFetchers > 0) {
            r = 0x6DDD00;
        }
        return r;
    }

    public List<Integer> getRolling() {
        return this.rolling;
    }

    public int getActiveFetchers() {
        return this.fetchService.getActiveCount();
    }

    public int getMaxFetchers() {
        return this.fetchService.getMaximumPoolSize();
    }

    public int getQueuedTasks() {
        return this.fetchService.getQueue().size();
    }

    public int getWorkers() {
        return this.fetchService.getPoolSize();
    }

    public boolean boardExists(String board) {
        boolean result = this.getBoards().contains(board);
        if (this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
            Debug.info("Checking " + board + ": " + result);
        }
        if (!result && this.plugin.getAConfig().getBoolean("fetching-de-bug")) {
            Debug.info("Boards: " + String.join((CharSequence)", ", this.getBoards()));
        }
        return result;
    }

    public Future<?> submit(Runnable task) {
        return this.fetchService.submit(task);
    }

    private void informAboutThreadLimit() {
        this.plugin.getLogger().warning("'unable to create native thread: possibly out of memory or process/resource limits reached' error detected! This is usually caused by your server hitting the limit on the number of threads it can have. If the server crashes, take the crash report and paste it into https://crash-report-analyser.ajg0702.us/ to help find which plugin is using too many threads. If you need help interpreting the results, feel free to ask in aj's discord server (invite link is on the ajLeaderboards plugin page under 'support')");
    }
}

