/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.cache;

import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.cache.Cache;
import us.ajg0702.leaderboards.cache.CacheMethod;
import us.ajg0702.leaderboards.cache.methods.H2Method;
import us.ajg0702.leaderboards.cache.methods.MysqlMethod;

public class ExtraManager {
    private final LeaderboardPlugin plugin;
    private final Cache cache;
    private final Map<String, String> CREATE_TABLE = ImmutableMap.of((Object)"sqlite", (Object)"create table if not exists '%s' (id TEXT, placeholder VARCHAR(255), value VARCHAR(2048))", (Object)"h2", (Object)"create table if not exists '%s' ('id' VARCHAR(36), 'placeholder' VARCHAR(255), 'value' VARCHAR(2048))", (Object)"mysql", (Object)"create table if not exists '%s' ('id' VARCHAR(36), 'placeholder' VARCHAR(255), 'value' VARCHAR(2048))");
    private final String QUERY_IDVALUE = "select id,'value' from '%s' where id=? and 'placeholder'=?";
    private final String INSERT_PLAYER = "insert into '%s' ('id', 'placeholder', 'value') values (?, ?, ?)";
    private final String UPDATE_PLAYER = "update '%s' set 'value'=? where id=? and 'placeholder'=?";
    private final CacheMethod method;
    private final String tableName;

    public ExtraManager(LeaderboardPlugin plugin) {
        this.plugin = plugin;
        this.cache = plugin.getCache();
        if (this.cache == null) {
            throw new IllegalStateException("Cache not found. Has it been loaded?");
        }
        this.method = this.cache.getMethod();
        this.tableName = this.cache.getTablePrefix() + "extras";
        try {
            Connection conn = this.method.getConnection();
            PreparedStatement ps = conn.prepareStatement(this.method.formatStatement(String.format(Objects.requireNonNull(this.CREATE_TABLE.get(this.method.getName())), this.tableName)));
            ps.executeUpdate();
            ps.close();
            this.method.close(conn);
        }
        catch (SQLException e) {
            plugin.getLogger().log(Level.SEVERE, "Failed to create storage for Extras:", e);
        }
    }

    public String getExtra(UUID id, String placeholder) {
        try {
            String value;
            ResultSet rs;
            PreparedStatement ps;
            Connection conn;
            block5: {
                conn = this.method.getConnection();
                ps = conn.prepareStatement(this.method.formatStatement(String.format(Objects.requireNonNull("select id,'value' from '%s' where id=? and 'placeholder'=?"), this.tableName)));
                ps.setString(1, id.toString());
                ps.setString(2, placeholder);
                rs = ps.executeQuery();
                if (this.method instanceof MysqlMethod || this.method instanceof H2Method) {
                    rs.next();
                }
                value = null;
                try {
                    value = rs.getString(2);
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("ResultSet closed") || e.getMessage().contains("empty result set") || e.getMessage().contains("[2000-")) break block5;
                    throw e;
                }
            }
            rs.close();
            ps.close();
            this.method.close(conn);
            return value;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "An error occurred while fetching an extra:", e);
            return "An error occurred";
        }
    }

    public List<String> getExtras() {
        ArrayList<String> extras = new ArrayList<String>();
        for (String extra : this.plugin.getAConfig().getStringList("extras")) {
            extra = extra.replaceAll(Matcher.quoteReplacement("%"), "");
            extras.add(extra);
        }
        return extras;
    }

    public boolean isExtra(String extra) {
        return this.getExtras().contains(extra);
    }

    public void setExtra(UUID id, String placeholder, String value) {
        if (this.plugin.isShuttingDown()) {
            return;
        }
        try {
            Connection conn = this.method.getConnection();
            PreparedStatement statement = conn.prepareStatement(String.format(this.method.formatStatement("update '%s' set 'value'=? where id=? and 'placeholder'=?"), this.tableName));
            statement.setString(1, value);
            statement.setString(2, id.toString());
            statement.setString(3, placeholder);
            int rowsChanged = statement.executeUpdate();
            statement.close();
            if (rowsChanged == 0) {
                PreparedStatement insertStmt = conn.prepareStatement(String.format(this.method.formatStatement("insert into '%s' ('id', 'placeholder', 'value') values (?, ?, ?)"), this.tableName));
                insertStmt.setString(1, id.toString());
                insertStmt.setString(2, placeholder);
                insertStmt.setString(3, value);
                insertStmt.executeUpdate();
                insertStmt.close();
            }
            this.method.close(conn);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.WARNING, "An error occurred while inserting an extra:", e);
        }
    }
}

