/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;
import us.ajg0702.leaderboards.utils.OfflineUpdater;

public class UpdateAllOffline
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public UpdateAllOffline(LeaderboardPlugin plugin) {
        super("updatealloffline", Collections.emptyList(), "ajleaderboards.use", "Attempts to update all offline players on the specified board.");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender sender, String[] args) {
        if (args.length == 1) {
            return this.filterCompletion(this.plugin.getTopManager().getBoards(), args[0]);
        }
        if (args.length == 2) {
            return Arrays.asList("start", "progress");
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (!this.checkPermission(sender)) {
            sender.sendMessage(this.plugin.getMessages().getComponent("noperm", new String[0]));
            return;
        }
        if (args.length < 1) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a board.\n&7Usage: /" + label + " updatealloffline <board> [start/progress]"));
            return;
        }
        String board = args[0];
        if (!this.plugin.getTopManager().boardExists(board)) {
            sender.sendMessage(LeaderboardPlugin.message("&cThat board does not exist!"));
            return;
        }
        if (args.length < 2 || args[1].equalsIgnoreCase("start")) {
            if (this.plugin.getOfflineUpdaters().containsKey(board)) {
                sender.sendMessage(LeaderboardPlugin.message("&cThat board is already being processed.\n&7To check it's progress, use &f/" + label + " updatealloffline " + board + " progress"));
                return;
            }
            OfflinePlayer[] offlinePlayers = Bukkit.getOfflinePlayers();
            this.plugin.getOfflineUpdaters().put(board, new OfflineUpdater(this.plugin, board, offlinePlayers, sender));
            sender.sendMessage(LeaderboardPlugin.message("&aStarted update of &f" + offlinePlayers.length + " &aplayers!\n&7You can check the progress by either checking the console, or running &f/" + label + " updatealloffline " + board + " progress\n&6Reminder: &7Not all placeholders support updating offline players, so if nothing is updated, it could be the fault of the placeholder, not ajLeaderboards."));
        } else if (args[1].equalsIgnoreCase("progress")) {
            if (!this.plugin.getOfflineUpdaters().containsKey(board)) {
                sender.sendMessage(LeaderboardPlugin.message("&cThat board is not being processed\n&7Start one using &f/" + label + " updatealloffline " + board + " start"));
                return;
            }
            OfflineUpdater offlineUpdater = this.plugin.getOfflineUpdaters().get(board);
            sender.sendMessage(LeaderboardPlugin.message("&6" + board + "&e: &6" + Math.round(offlineUpdater.getProgressPercent() * 1000.0) / 10L + "&e% done (&6" + offlineUpdater.getRemainingPlayers() + " &e/&6 " + offlineUpdater.getStarted() + "&e)"));
        } else {
            sender.sendMessage(LeaderboardPlugin.message("&cInvalid argument!\n&7Usage: /" + label + " updatealloffline <board> [start/progress]"));
        }
    }
}

