/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;
import us.ajg0702.leaderboards.commands.main.subcommands.CheckUpdate;

public class UpdatePlayer
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public UpdatePlayer(LeaderboardPlugin plugin) {
        super("updateplayer", Collections.emptyList(), "ajleaderboards.use", "Attempt to manually update a player's stats on the leaderboard");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] args) {
        if (args.length == 2) {
            return null;
        }
        if (args.length == 1) {
            ArrayList<String> boards = new ArrayList<String>(this.plugin.getTopManager().getBoards());
            boards.add("*");
            return this.filterCompletion(boards, args[0]);
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        if (args.length < 2) {
            sender.sendMessage(LeaderboardPlugin.message("&cPlease provide a board and player to update\n&7Usage: /" + label + " update <board> <player>"));
            return;
        }
        this.plugin.getScheduler().runTaskAsynchronously(() -> {
            String board = args[0];
            if (!this.plugin.getCache().boardExists(board) && !board.equals("*")) {
                sender.sendMessage(LeaderboardPlugin.message("&cThe board '" + board + "' does not exist."));
                return;
            }
            OfflinePlayer p = Bukkit.getOfflinePlayer((String)args[1]);
            if (board.equals("*")) {
                this.plugin.getCache().updatePlayerStats(p);
            } else {
                this.plugin.getCache().updateStat(board, p);
            }
            boolean attemptHasWarning = CheckUpdate.checkUpdate(board, p, this.plugin, sender);
            sender.sendMessage(LeaderboardPlugin.message("&" + (attemptHasWarning ? "e" : "a") + "Attempted to update stat for " + p.getName() + " on " + (board.equals("*") ? "all boards" : "board " + board)));
        });
    }
}

