/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.app.builder;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.function.Function;
import us.ajg0702.leaderboards.libs.slimjar.app.AppendingApplication;
import us.ajg0702.leaderboards.libs.slimjar.app.Application;
import us.ajg0702.leaderboards.libs.slimjar.app.builder.ApplicationBuilder;
import us.ajg0702.leaderboards.libs.slimjar.injector.DependencyInjector;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.Injectable;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.InjectableFactory;
import us.ajg0702.leaderboards.libs.slimjar.resolver.ResolutionResult;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.DependencyData;
import us.ajg0702.leaderboards.libs.slimjar.resolver.reader.dependency.DependencyDataProvider;
import us.ajg0702.leaderboards.libs.slimjar.resolver.reader.resolution.PreResolutionDataProvider;

public final class InjectingApplicationBuilder
extends ApplicationBuilder {
    private final Function<ApplicationBuilder, Injectable> injectableSupplier;

    public InjectingApplicationBuilder(String applicationName, Injectable injectable) {
        this(applicationName, (ApplicationBuilder it) -> injectable);
    }

    public InjectingApplicationBuilder(String applicationName, Function<ApplicationBuilder, Injectable> injectableSupplier) {
        super(applicationName);
        this.injectableSupplier = injectableSupplier;
    }

    @Override
    public Application buildApplication() throws IOException, ReflectiveOperationException, URISyntaxException, NoSuchAlgorithmException {
        DependencyDataProvider dataProvider = this.getDataProviderFactory().create(this.getDependencyFileUrl());
        DependencyData dependencyData = dataProvider.get();
        DependencyInjector dependencyInjector = this.createInjector();
        PreResolutionDataProvider preResolutionDataProvider = this.getPreResolutionDataProviderFactory().create(this.getPreResolutionFileUrl());
        Map<String, ResolutionResult> preResolutionResultMap = preResolutionDataProvider.get();
        dependencyInjector.inject(this.injectableSupplier.apply(this), dependencyData, preResolutionResultMap);
        return new AppendingApplication();
    }

    public static ApplicationBuilder createAppending(String applicationName) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        ClassLoader classLoader = ApplicationBuilder.class.getClassLoader();
        return InjectingApplicationBuilder.createAppending(applicationName, classLoader);
    }

    public static ApplicationBuilder createAppending(String applicationName, ClassLoader classLoader) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        return new InjectingApplicationBuilder(applicationName, builder -> {
            try {
                return InjectableFactory.create(builder.getDownloadDirectoryPath(), builder.getInternalRepositories(), classLoader);
            }
            catch (IOException | ReflectiveOperationException | URISyntaxException | NoSuchAlgorithmException exception) {
                exception.printStackTrace();
                return null;
            }
        });
    }
}

