/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.injector;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import us.ajg0702.leaderboards.libs.slimjar.injector.DependencyInjector;
import us.ajg0702.leaderboards.libs.slimjar.injector.InjectionFailedException;
import us.ajg0702.leaderboards.libs.slimjar.injector.helper.InjectionHelper;
import us.ajg0702.leaderboards.libs.slimjar.injector.helper.InjectionHelperFactory;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.Injectable;
import us.ajg0702.leaderboards.libs.slimjar.resolver.ResolutionResult;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.DependencyData;

public final class SimpleDependencyInjector
implements DependencyInjector {
    private final InjectionHelperFactory injectionHelperFactory;

    public SimpleDependencyInjector(InjectionHelperFactory injectionHelperFactory) {
        this.injectionHelperFactory = injectionHelperFactory;
    }

    @Override
    public void inject(Injectable injectable, DependencyData data, Map<String, ResolutionResult> preResolvedResults) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        InjectionHelper helper = this.injectionHelperFactory.create(data, preResolvedResults);
        this.injectDependencies(injectable, helper, data.getDependencies());
    }

    private void injectDependencies(Injectable injectable, InjectionHelper injectionHelper, Collection<Dependency> dependencies) throws ReflectiveOperationException {
        for (Dependency dependency : dependencies) {
            try {
                File depJar = injectionHelper.fetch(dependency);
                if (depJar == null) continue;
                injectable.inject(depJar.toURI().toURL());
                this.injectDependencies(injectable, injectionHelper, dependency.getTransitive());
            }
            catch (IOException e) {
                throw new InjectionFailedException(dependency, e);
            }
            catch (IllegalAccessException | InvocationTargetException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }
}

