/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.injector.helper;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Map;
import us.ajg0702.leaderboards.libs.slimjar.downloader.DependencyDownloader;
import us.ajg0702.leaderboards.libs.slimjar.downloader.DependencyDownloaderFactory;
import us.ajg0702.leaderboards.libs.slimjar.downloader.output.DependencyOutputWriterFactory;
import us.ajg0702.leaderboards.libs.slimjar.downloader.strategy.FilePathStrategy;
import us.ajg0702.leaderboards.libs.slimjar.downloader.verify.DependencyVerifierFactory;
import us.ajg0702.leaderboards.libs.slimjar.injector.DependencyInjectorFactory;
import us.ajg0702.leaderboards.libs.slimjar.injector.helper.InjectionHelper;
import us.ajg0702.leaderboards.libs.slimjar.relocation.Relocator;
import us.ajg0702.leaderboards.libs.slimjar.relocation.RelocatorFactory;
import us.ajg0702.leaderboards.libs.slimjar.relocation.helper.RelocationHelper;
import us.ajg0702.leaderboards.libs.slimjar.relocation.helper.RelocationHelperFactory;
import us.ajg0702.leaderboards.libs.slimjar.resolver.DependencyResolver;
import us.ajg0702.leaderboards.libs.slimjar.resolver.DependencyResolverFactory;
import us.ajg0702.leaderboards.libs.slimjar.resolver.ResolutionResult;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.DependencyData;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;
import us.ajg0702.leaderboards.libs.slimjar.resolver.enquirer.RepositoryEnquirerFactory;
import us.ajg0702.leaderboards.libs.slimjar.resolver.mirrors.MirrorSelector;
import us.ajg0702.leaderboards.libs.slimjar.resolver.reader.dependency.DependencyDataProviderFactory;

public final class InjectionHelperFactory {
    private final Path downloadDirectoryPath;
    private final RelocatorFactory relocatorFactory;
    private final RelocationHelperFactory relocationHelperFactory;
    private final DependencyResolverFactory resolverFactory;
    private final RepositoryEnquirerFactory enquirerFactory;
    private final DependencyDownloaderFactory downloaderFactory;
    private final DependencyVerifierFactory verifier;
    private final MirrorSelector mirrorSelector;

    public InjectionHelperFactory(Path downloadDirectoryPath, RelocatorFactory relocatorFactory, DependencyDataProviderFactory dataProviderFactory, RelocationHelperFactory relocationHelperFactory, DependencyInjectorFactory injectorFactory, DependencyResolverFactory resolverFactory, RepositoryEnquirerFactory enquirerFactory, DependencyDownloaderFactory downloaderFactory, DependencyVerifierFactory verifier, MirrorSelector mirrorSelector) {
        this.downloadDirectoryPath = downloadDirectoryPath;
        this.relocatorFactory = relocatorFactory;
        this.relocationHelperFactory = relocationHelperFactory;
        this.resolverFactory = resolverFactory;
        this.enquirerFactory = enquirerFactory;
        this.downloaderFactory = downloaderFactory;
        this.verifier = verifier;
        this.mirrorSelector = mirrorSelector;
    }

    public InjectionHelper create(DependencyData data, Map<String, ResolutionResult> preResolvedResults) throws IOException, NoSuchAlgorithmException, URISyntaxException {
        Collection<Repository> repositories = this.mirrorSelector.select(data.getRepositories(), data.getMirrors());
        Relocator relocator = this.relocatorFactory.create(data.getRelocations());
        RelocationHelper relocationHelper = this.relocationHelperFactory.create(relocator);
        FilePathStrategy filePathStrategy = FilePathStrategy.createDefault(this.downloadDirectoryPath.toFile());
        DependencyOutputWriterFactory outputWriterFactory = new DependencyOutputWriterFactory(filePathStrategy);
        DependencyResolver resolver = this.resolverFactory.create(repositories, preResolvedResults, this.enquirerFactory);
        DependencyDownloader downloader = this.downloaderFactory.create(outputWriterFactory, resolver, this.verifier.create(resolver));
        return new InjectionHelper(downloader, relocationHelper);
    }
}

