/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.injector.loader;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import us.ajg0702.leaderboards.libs.slimjar.app.builder.ApplicationBuilder;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.Injectable;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.InstrumentationInjectable;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.UnsafeInjectable;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.WrappedInjectableClassLoader;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;

public final class InjectableFactory {
    private InjectableFactory() {
    }

    public static Injectable create(Path downloadPath, Collection<Repository> repositories) throws ReflectiveOperationException, NoSuchAlgorithmException, IOException, URISyntaxException {
        return InjectableFactory.create(downloadPath, repositories, InjectableFactory.class.getClassLoader());
    }

    public static Injectable create(Path downloadPath, Collection<Repository> repositories, ClassLoader classLoader) throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        boolean isJigsawActive = InjectableFactory.isJigsawActive();
        Injectable injectable = null;
        if (isJigsawActive && classLoader instanceof URLClassLoader) {
            injectable = new WrappedInjectableClassLoader((URLClassLoader)ApplicationBuilder.class.getClassLoader());
        } else if (InjectableFactory.isUnsafeAvailable() && classLoader instanceof URLClassLoader) {
            try {
                injectable = UnsafeInjectable.create((URLClassLoader)classLoader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (injectable == null) {
            injectable = InstrumentationInjectable.create(downloadPath, repositories);
        }
        return injectable;
    }

    private static boolean isJigsawActive() {
        try {
            Class.forName("java.lang.Module");
        }
        catch (ClassNotFoundException e) {
            return true;
        }
        return false;
    }

    private static boolean isUnsafeAvailable() {
        try {
            Class.forName("sun.misc.Unsafe");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return true;
    }
}

