/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.commands.main.subcommands;

import java.util.Collections;
import java.util.List;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.boards.StatEntry;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.commands.base.CommandSender;
import us.ajg0702.leaderboards.commands.base.SubCommand;

public class ListCommand
extends SubCommand {
    private final LeaderboardPlugin plugin;

    public ListCommand(LeaderboardPlugin plugin) {
        super("list", Collections.emptyList(), "ajleaderboards.use", "List all boards in ajleaderboards, or list the top 10 players in a certain board.");
        this.plugin = plugin;
    }

    @Override
    public List<String> autoComplete(CommandSender commandSender, String[] args) {
        if (args.length <= 1) {
            return this.filterCompletion(this.plugin.getTopManager().getBoards(), args[0]);
        }
        if (args.length == 2) {
            return this.filterCompletion(TimedType.lowerNames(), args[1]);
        }
        return Collections.emptyList();
    }

    @Override
    public void execute(CommandSender sender, String[] args, String label) {
        this.plugin.getScheduler().runTaskAsynchronously(() -> {
            TimedType timedType;
            if (args.length < 1) {
                StringBuilder list = new StringBuilder("&6Boards");
                for (String boardn : this.plugin.getTopManager().getBoards()) {
                    list.append("\n&7- &e").append(boardn);
                }
                sender.sendMessage(LeaderboardPlugin.message(list.toString()));
                return;
            }
            String board = args[0];
            TimedType timedType2 = timedType = args.length > 1 ? TimedType.of(args[1]) : TimedType.ALLTIME;
            if (!this.plugin.getCache().boardExists(board)) {
                sender.sendMessage(LeaderboardPlugin.message("&cThe board '" + board + "' does not exist."));
                return;
            }
            StringBuilder list = new StringBuilder("&6Top for " + board + " " + timedType.lowerName());
            for (int i = 1; i <= 10; ++i) {
                StatEntry e = this.plugin.getCache().getStat(i, board, timedType);
                list.append("\n&6").append(i).append(". &e").append(e.getPlayerName()).append(" &7- &e").append(e.getScorePretty());
            }
            sender.sendMessage(LeaderboardPlugin.message(list.toString()));
        });
    }
}

