/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.utils.common;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import net.md_5.bungee.api.chat.BaseComponent;
import org.bukkit.entity.Player;
import us.ajg0702.leaderboards.libs.configurate.CommentedConfigurationNode;
import us.ajg0702.leaderboards.libs.configurate.ConfigurationNode;
import us.ajg0702.leaderboards.libs.configurate.serialize.SerializationException;
import us.ajg0702.leaderboards.libs.configurate.yaml.NodeStyle;
import us.ajg0702.leaderboards.libs.configurate.yaml.YamlConfigurationLoader;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.Component;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.TextComponent;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.MiniMessage;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.serializer.bungeecord.BungeeComponentSerializer;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import us.ajg0702.leaderboards.libs.utils.common.ConfigFile;

public class Messages {
    File msgFile;
    File pluginFolder;
    YamlConfigurationLoader loader;
    ConfigFile config;
    CommentedConfigurationNode msgs;
    Logger logger;
    Map<String, Object> defaultValues;
    Map<String, String> moving;
    private final Random random = new Random();
    private final LegacyComponentSerializer legacyComponentSerializer = LegacyComponentSerializer.legacySection();
    private MiniMessage miniMessage;
    private static final ImmutableMap<String, String> colorReplacements = new ImmutableMap.Builder().put((Object)"0", (Object)"<black>").put((Object)"1", (Object)"<dark_blue>").put((Object)"2", (Object)"<dark_green>").put((Object)"3", (Object)"<dark_aqua>").put((Object)"4", (Object)"<dark_red>").put((Object)"5", (Object)"<dark_purple>").put((Object)"6", (Object)"<gold>").put((Object)"7", (Object)"<gray>").put((Object)"8", (Object)"<dark_gray>").put((Object)"9", (Object)"<blue>").put((Object)"a", (Object)"<green>").put((Object)"b", (Object)"<aqua>").put((Object)"c", (Object)"<red>").put((Object)"d", (Object)"<light_purple>").put((Object)"e", (Object)"<yellow>").put((Object)"f", (Object)"<white>").put((Object)"k", (Object)"<magic>").put((Object)"l", (Object)"<bold>").put((Object)"m", (Object)"<strikethrough>").put((Object)"n", (Object)"<underlined>").put((Object)"o", (Object)"<italic>").put((Object)"r", (Object)"<reset>").build();
    private static Boolean hasPapi;

    public Messages(File pluginFolder, Logger logger, Map<String, Object> defaultValues, Map<String, String> moving) {
        this.logger = logger;
        this.pluginFolder = pluginFolder;
        this.defaultValues = defaultValues;
        this.moving = moving;
        this.loadMessagesFile(defaultValues, moving);
    }

    public Messages(File pluginFolder, Logger logger, Map<String, Object> defaultValues) {
        this.logger = logger;
        this.pluginFolder = pluginFolder;
        this.defaultValues = defaultValues;
        this.moving = new HashMap<String, String>();
        this.loadMessagesFile(defaultValues, this.moving);
    }

    private void loadMessagesFile(Map<String, Object> defaultMessages, Map<String, String> moving) {
        this.msgFile = new File(this.pluginFolder, "messages.yml");
        this.loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().file(this.msgFile)).nodeStyle(NodeStyle.BLOCK).build();
        try {
            this.msgs = (CommentedConfigurationNode)this.loader.load();
        }
        catch (IOException e) {
            this.logger.severe("Unable to load messages file:");
            e.printStackTrace();
            return;
        }
        for (String rkey : moving.keySet()) {
            ConfigurationNode node;
            Object[] key = rkey.split("\\.");
            if (!this.msgs.hasChild(key) || !(node = this.msgs.node(key)).isList()) continue;
            try {
                ((CommentedConfigurationNode)this.msgs.node(new Object[]{moving.get(rkey)})).set(((CommentedConfigurationNode)this.msgs.node(key)).getList(String.class));
            }
            catch (SerializationException e) {
                this.logger.log(Level.SEVERE, "Unable to move message:", e);
            }
        }
        for (String key : defaultMessages.keySet()) {
            if (this.msgs.hasChild(key.split("\\."))) continue;
            try {
                ((CommentedConfigurationNode)((CommentedConfigurationNode)this.msgs.node(key.split("\\."))).node(new Object[0])).set(defaultMessages.get(key));
            }
            catch (SerializationException e) {
                this.logger.log(Level.SEVERE, "Unable to set message in file:", e);
            }
        }
        try {
            this.loader.save(this.msgs);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unable to save messages file:", e);
        }
    }

    @Deprecated
    public String get(String key) {
        String msg = ((CommentedConfigurationNode)this.msgs.node(key.split("\\."))).getString("&cMessage '" + key + "' does not exist!");
        msg = Messages.color(msg);
        return msg;
    }

    public String getRawString(String key, String ... placeholders) {
        String msg = ((CommentedConfigurationNode)this.msgs.node(key.split("\\."))).getString("&cMessage '" + key + "' does not exist!");
        for (String sr : placeholders) {
            String placeholder = sr.split(":")[0];
            String value = sr.replaceFirst(Matcher.quoteReplacement(placeholder + ":"), "");
            msg = msg.replaceAll("\\{" + Matcher.quoteReplacement(placeholder) + "}", value);
        }
        return msg;
    }

    public String getString(String key, String ... placeholders) {
        String msg = ((CommentedConfigurationNode)this.msgs.node(key.split("\\."))).getString("&cMessage '" + key + "' does not exist!");
        for (String sr : placeholders) {
            String placeholder = sr.split(":")[0];
            String value = sr.replaceFirst(Matcher.quoteReplacement(placeholder + ":"), "");
            msg = msg.replaceAll("\\{" + Matcher.quoteReplacement(placeholder) + "}", value);
        }
        msg = Messages.color(msg);
        return msg;
    }

    public List<String> getStringList(String key, String ... placeholders) {
        List<Object> msgs;
        try {
            if (this.hasMessage(key)) {
                msgs = ((CommentedConfigurationNode)this.msgs.node(key.split("\\."))).getList(String.class);
                if (msgs != null) {
                    msgs = new ArrayList(msgs);
                }
            } else {
                msgs = new ArrayList<String>();
                msgs.add("&cMessage '" + key + "' does not exist!");
            }
        }
        catch (SerializationException e) {
            this.logger.log(Level.WARNING, "List '" + key + "' must be all strings!", e);
            return new ArrayList<String>();
        }
        for (int i = 0; i < msgs.size(); ++i) {
            String msg = Messages.color((String)msgs.get(i));
            for (String sr : placeholders) {
                String placeholder = sr.split(":")[0];
                String value = sr.replaceFirst(Matcher.quoteReplacement(placeholder + ":"), "");
                msg = msg.replaceAll("\\{" + Matcher.quoteReplacement(placeholder) + "}", value);
            }
            msgs.set(i, msg);
        }
        return msgs;
    }

    public List<String> getMMStringList(String key, String ... placeholders) {
        List<String> msgs = this.getStringList(key, placeholders);
        for (int i = 0; i < msgs.size(); ++i) {
            String msg = msgs.get(i);
            Object component = this.getMiniMessage().deserialize(msg);
            msg = this.legacyComponentSerializer.serialize((Component)component);
            msgs.set(i, msg);
        }
        return msgs;
    }

    public String getMMString(String key, String ... placeholders) {
        return this.getMMString(key, false, placeholders);
    }

    public String getMMString(String key, boolean preserveColor, String ... placeholders) {
        String msg = this.getString(key, placeholders);
        if (preserveColor) {
            msg = msg + "a";
        }
        Object component = this.getMiniMessage().deserialize(msg);
        msg = this.legacyComponentSerializer.serialize((Component)component);
        if (preserveColor) {
            msg = msg.substring(0, msg.length() - 1);
        }
        return msg;
    }

    public List<Component> getComponentList(String key, String ... placeholders) {
        ArrayList<Component> r = new ArrayList<Component>();
        List<String> msgs = this.getStringList(key, placeholders);
        for (String s : msgs) {
            r.add(this.toComponent(s));
        }
        return r;
    }

    public boolean hasMessage(String key) {
        ConfigurationNode node = this.msgs.node(key.split("\\."));
        return !node.virtual() && !node.isNull();
    }

    public Component getRandomFromList(String key, String ... placeholders) {
        List<String> msgs = this.getStringList(key, placeholders);
        String msg = msgs.get(this.random.nextInt(msgs.size() - 1));
        return this.toComponent(msg);
    }

    public boolean isEmpty(String key) {
        return this.getString(key, new String[0]).length() == 0;
    }

    public BaseComponent[] getBC(String key, String ... placeholders) {
        return this.getBC(this.getComponent(key, placeholders));
    }

    public BaseComponent[] getBC(Component component) {
        return BungeeComponentSerializer.get().serialize(component);
    }

    public Component getComponent(String key, String ... placeholders) {
        String m = this.getString(key, placeholders);
        return this.getMiniMessage().deserialize(m);
    }

    public MiniMessage getMiniMessage() {
        if (this.miniMessage == null) {
            this.miniMessage = MiniMessage.miniMessage();
        }
        return this.miniMessage;
    }

    public Component toComponent(String message) {
        return this.getMiniMessage().deserialize(Messages.color(message));
    }

    public static String color(String msg) {
        for (Map.Entry entry : colorReplacements.entrySet()) {
            String legacy = (String)entry.getKey();
            String mini = (String)entry.getValue();
            msg = msg.replaceAll(Matcher.quoteReplacement("&" + legacy), Matcher.quoteReplacement(mini));
            msg = msg.replaceAll(Matcher.quoteReplacement('\u00b7' + legacy), Matcher.quoteReplacement(mini));
        }
        return msg;
    }

    public void reload() {
        this.loadMessagesFile(this.defaultValues, this.moving);
    }

    public CommentedConfigurationNode getRootNode() {
        return this.msgs;
    }

    public void save() {
        try {
            this.loader.save(this.msgs);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "Unable to save messages file:", e);
        }
    }

    public static Map<String, Object> makeDefaults(Object ... args) {
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        for (int i = 0; i < args.length; i += 2) {
            if (!(args[i] instanceof String)) {
                throw new IllegalArgumentException("Key must be string! It was " + args[i].toString());
            }
            if (i + 1 >= args.length) {
                throw new IllegalArgumentException("Odd arguments supplied! (must have a key and a value)");
            }
            defaults.put((String)args[i], args[i + 1]);
        }
        return defaults;
    }

    public static boolean hasPlaceholderAPI() {
        if (hasPapi == null) {
            try {
                Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                hasPapi = true;
            }
            catch (ClassNotFoundException e) {
                hasPapi = false;
            }
        }
        return hasPapi;
    }

    public static Component setPlaceholders(Player player, Component component) {
        if (!Messages.hasPlaceholderAPI()) {
            return component;
        }
        return Messages.recurseSetPlaceholders(player, component);
    }

    private static Component recurseSetPlaceholders(Player player, Component component) {
        if (!(component instanceof TextComponent)) {
            return component;
        }
        TextComponent textComponent = (TextComponent)component;
        Component newComponent = textComponent.content(PlaceholderAPI.setPlaceholders((Player)player, (String)textComponent.content()));
        if (newComponent.children().size() > 0) {
            ArrayList<Component> newChildren = new ArrayList<Component>();
            for (Component child : newComponent.children()) {
                newChildren.add(Messages.recurseSetPlaceholders(player, child));
            }
            newComponent = newComponent.children(newChildren);
        }
        return newComponent;
    }
}

