/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.boards;

import com.google.gson.JsonObject;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.TimeUtils;
import us.ajg0702.leaderboards.boards.TimedType;
import us.ajg0702.leaderboards.boards.keys.BoardType;
import us.ajg0702.leaderboards.cache.Cache;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.NotNull;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.Nullable;
import us.ajg0702.leaderboards.libs.utils.common.Messages;
import us.ajg0702.leaderboards.utils.EasyJsonObject;

public class StatEntry {
    public static final String BOARD_DOES_NOT_EXIST = "Board does not exist";
    public static final String AN_ERROR_OCCURRED = "An error occurred";
    private static LeaderboardPlugin plugin;
    @Nullable
    final String playerName;
    final String playerDisplayName;
    String prefix;
    String suffix;
    final UUID playerID;
    final int position;
    final String board;
    private final Cache cache;
    private final TimedType type;
    static boolean formatStringsSet;
    static String k;
    static String m;
    static String b;
    static String t;
    static String q;
    static String qi;
    static String sx;
    static String sp;
    static String o;
    static String n;
    static String d;
    static String ud;
    double score;
    String scorePretty;

    public StatEntry(int position, String board, String prefix, @Nullable String playerName, String playerDisplayName, UUID playerID, String suffix, double score, TimedType type) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (suffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        this.playerName = playerName == null ? "" : playerName;
        this.playerDisplayName = playerDisplayName == null ? "" : playerDisplayName;
        this.score = score;
        this.prefix = prefix;
        this.suffix = suffix;
        this.type = type;
        this.playerID = playerID;
        this.cache = plugin.getCache();
        if (plugin != null && !formatStringsSet) {
            formatStringsSet = true;
            try {
                Messages msgs = plugin.getMessages();
                k = msgs.getString("formatted.k", new String[0]);
                m = msgs.getString("formatted.m", new String[0]);
                b = msgs.getString("formatted.b", new String[0]);
                t = msgs.getString("formatted.t", new String[0]);
                q = msgs.getString("formatted.q", new String[0]);
                qi = msgs.getString("formatted.qi", new String[0]);
                sx = msgs.getString("formatted.sx", new String[0]);
                sp = msgs.getString("formatted.sp", new String[0]);
                o = msgs.getString("formatted.o", new String[0]);
                n = msgs.getString("formatted.n", new String[0]);
                d = msgs.getString("formatted.d", new String[0]);
                ud = msgs.getString("formatted.ud", new String[0]);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        this.position = position;
        this.board = board;
        this.scorePretty = this.calcPrettyScore();
    }

    private String calcPrettyScore() {
        if (this.score == 0.0 && BOARD_DOES_NOT_EXIST.equals(this.playerName)) {
            return "BDNE";
        }
        if (this.score == 0.0 && plugin.getMessages().getRawString("loading.text", new String[0]).equals(this.playerName)) {
            return "...";
        }
        Messages messages = this.cache.getPlugin().getMessages();
        if (!this.hasPlayer()) {
            if (this.score == -1.0) {
                return messages.getRawString("no-data.lb.value", new String[0]);
            }
            if (this.score == -2.0) {
                return messages.getRawString("no-data.rel.value", new String[0]);
            }
            return plugin.getMessages().getRawString("loading.short", new String[0]);
        }
        return plugin.getPlaceholderFormatter().toFormat(this.score, this.board);
    }

    public void changeScore(double newScore, String newPrefix, String newSuffix) {
        if (newPrefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null");
        }
        if (newSuffix == null) {
            throw new IllegalArgumentException("Suffix cannot be null");
        }
        this.score = newScore;
        this.prefix = newPrefix;
        this.suffix = newSuffix;
        this.scorePretty = this.calcPrettyScore();
    }

    public boolean hasPlayer() {
        return this.getPlayerID() != null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getPlayerName() {
        return this.playerName == null ? "N/A" : this.playerName;
    }

    public String getSkin() {
        if (this.playerID != null) {
            return this.playerName;
        }
        if (plugin.getMessages().hasMessage("no-player-skin." + this.board)) {
            return plugin.getMessages().getRawString("no-player-skin." + this.board, new String[0]);
        }
        return plugin.getMessages().getRawString("no-player-skin.default", new String[0]);
    }

    public UUID getSkinUUID() {
        if (this.playerID != null) {
            return this.playerID;
        }
        if (plugin.getMessages().hasMessage("no-player-skin-uuid." + this.board)) {
            return UUID.fromString(plugin.getMessages().getRawString("no-player-skin-uuid." + this.board, new String[0]));
        }
        return UUID.fromString(plugin.getMessages().getRawString("no-player-skin-uuid.default", new String[0]));
    }

    @NotNull
    public String getPlayerDisplayName() {
        return this.playerDisplayName;
    }

    public UUID getPlayerID() {
        return this.playerID;
    }

    public int getPosition() {
        return this.position;
    }

    public String getBoard() {
        return this.board;
    }

    public TimedType getType() {
        return this.type;
    }

    public double getScore() {
        return this.score;
    }

    public String getScoreFormatted() {
        if (this.score == 0.0 && BOARD_DOES_NOT_EXIST.equals(this.playerName)) {
            return "BDNE";
        }
        if (!this.hasPlayer()) {
            if (this.cache != null) {
                if (this.score == -1.0) {
                    return plugin.getMessages().getRawString("no-data.lb.value", new String[0]);
                }
                if (this.score == -2.0) {
                    return plugin.getMessages().getRawString("no-data.rel.value", new String[0]);
                }
                return plugin.getMessages().getRawString("loading.short", new String[0]);
            }
            return "---";
        }
        return StatEntry.formatDouble(this.score);
    }

    public String getColor() {
        if (this.prefix.isEmpty()) {
            return "";
        }
        StringBuilder colors = new StringBuilder();
        int i = 0;
        for (char c : this.prefix.toCharArray()) {
            if (i == this.prefix.length() - 1) break;
            if (c == '&' || c == '\u00a7') {
                colors.append(c);
                char nextChar = this.prefix.charAt(i + 1);
                colors.append(nextChar);
                if (nextChar == '#') {
                    colors.append(this.prefix, i + 2, i + 8);
                }
            }
            ++i;
        }
        return colors.toString();
    }

    public static String formatDouble(double number) {
        if (number < 1000.0) {
            return StatEntry.formatNumber(number);
        }
        if (number < 1000000.0) {
            return StatEntry.formatNumber(number / 1000.0) + k;
        }
        if (number < 1.0E9) {
            return StatEntry.formatNumber(number / 1000000.0) + m;
        }
        if (number < 1.0E12) {
            return StatEntry.formatNumber(number / 1.0E9) + b;
        }
        if (number < 1.0E15) {
            return StatEntry.formatNumber(number / 1.0E12) + t;
        }
        if (number < 1.0E18) {
            return StatEntry.formatNumber(number / 1.0E15) + q;
        }
        if (number < 1.0E21) {
            return StatEntry.formatNumber(number / 1.0E18) + qi;
        }
        if (number < 1.0E24) {
            return StatEntry.formatNumber(number / 1.0E21) + sx;
        }
        if (number < 1.0E27) {
            return StatEntry.formatNumber(number / 1.0E24) + sp;
        }
        if (number < 1.0E30) {
            return StatEntry.formatNumber(number / 1.0E27) + o;
        }
        if (number < 1.0E33) {
            return StatEntry.formatNumber(number / 1.0E30) + n;
        }
        if (number < 1.0E36) {
            return StatEntry.formatNumber(number / 1.0E33) + d;
        }
        if (number < 1.0E39) {
            return StatEntry.formatNumber(number / 1.0E36) + ud;
        }
        return StatEntry.addCommas(number);
    }

    private static String formatNumber(double d) {
        NumberFormat format = NumberFormat.getInstance();
        format.setMaximumFractionDigits(2);
        format.setMinimumFractionDigits(0);
        return format.format(d);
    }

    public String getScorePretty() {
        return this.scorePretty;
    }

    public String getTime() {
        if (this.score == 0.0 && BOARD_DOES_NOT_EXIST.equals(this.playerName)) {
            return "BDNE";
        }
        if (!this.hasPlayer()) {
            if (this.score == -1.0) {
                return plugin.getMessages().getRawString("no-data.lb.value", new String[0]);
            }
            if (this.score == -2.0) {
                return plugin.getMessages().getRawString("no-data.rel.value", new String[0]);
            }
            return plugin.getMessages().getRawString("loading.short", new String[0]);
        }
        return TimeUtils.formatTimeSeconds(Math.round(this.getScore()));
    }

    public static String addCommas(double number) {
        return StatEntry.addCommas(number, null);
    }

    public static String addCommas(double number, @Nullable String board) {
        char decimal;
        boolean useComma = true;
        char comma = '\u0000';
        if (plugin != null) {
            String commaString = plugin.getAConfig().getString("comma");
            boolean bl = useComma = !commaString.isEmpty();
            if (useComma) {
                comma = commaString.charAt(0);
            }
            decimal = plugin.getAConfig().getString("decimal").charAt(0);
        } else {
            comma = ',';
            decimal = '.';
        }
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.getDefault(Locale.Category.FORMAT));
        if (useComma) {
            symbols.setGroupingSeparator(comma);
        }
        symbols.setDecimalSeparator(decimal);
        DecimalFormat df = new DecimalFormat("#,###.##", symbols);
        df.setGroupingUsed(useComma);
        if (board != null) {
            for (String s : plugin.getAConfig().getStringList("show-zero-decimal")) {
                if (s.startsWith("%") || s.endsWith("%")) {
                    plugin.getLogger().warning("Invalid entry for show-zero-decimal '" + s + "'. Make sure to not include '%' in the board name!");
                    continue;
                }
                if (!s.toLowerCase().startsWith(board.toLowerCase())) continue;
                int minDecimals = 1;
                if (s.contains("%")) {
                    String[] parts = s.split("%");
                    String realBoard = parts[0];
                    String rawMin = parts[1];
                    if (realBoard.equalsIgnoreCase(board)) continue;
                    try {
                        minDecimals = Integer.parseInt(rawMin);
                    }
                    catch (NumberFormatException e) {
                        plugin.getLogger().warning("Invalid entry for show-zero-decimal '" + s + "'. The minimum decimals, if specified, must be a number!");
                    }
                }
                df.setMinimumFractionDigits(minDecimals);
            }
        }
        return df.format(number);
    }

    @Deprecated
    public String getPlayer() {
        return this.playerName;
    }

    public static StatEntry boardNotFound(int position, String board, TimedType type) {
        return new StatEntry(position, board, "", BOARD_DOES_NOT_EXIST, BOARD_DOES_NOT_EXIST, null, "", 0.0, type);
    }

    public static StatEntry error(int position, String board, TimedType type) {
        return new StatEntry(position, board, "", AN_ERROR_OCCURRED, AN_ERROR_OCCURRED, null, "", 0.0, type);
    }

    public static StatEntry noData(LeaderboardPlugin plugin, int position, String board, TimedType type) {
        return new StatEntry(position, board, "", plugin.getMessages().getRawString("no-data.lb.name", new String[0]), plugin.getMessages().getRawString("no-data.lb.name", new String[0]), null, "", -1.0, type);
    }

    public static StatEntry noRelData(LeaderboardPlugin plugin, int position, String board, TimedType type) {
        return new StatEntry(position, board, "", plugin.getMessages().getRawString("no-data.rel.name", new String[0]), plugin.getMessages().getRawString("no-data.rel.name", new String[0]), null, "", -2.0, type);
    }

    public static StatEntry loading(LeaderboardPlugin plugin, int position, String board, TimedType type) {
        return new StatEntry(position, board, "", plugin.getMessages().getRawString("loading.text", new String[0]), plugin.getMessages().getRawString("loading.text", new String[0]), null, "", 0.0, type);
    }

    public static StatEntry loading(LeaderboardPlugin plugin, String board, TimedType type) {
        return new StatEntry(-2, board, "", plugin.getMessages().getRawString("loading.text", new String[0]), plugin.getMessages().getRawString("loading.text", new String[0]), null, "", 0.0, type);
    }

    public static StatEntry loading(LeaderboardPlugin plugin, BoardType boardType) {
        return new StatEntry(-2, boardType.getBoard(), "", plugin.getMessages().getRawString("loading.text", new String[0]), plugin.getMessages().getRawString("loading.text", new String[0]), null, "", 0.0, boardType.getType());
    }

    public static StatEntry loading(OfflinePlayer player, BoardType boardType) {
        return new StatEntry(-2, boardType.getBoard(), "", player.getName(), player.getName(), player.getUniqueId(), "", 0.0, boardType.getType());
    }

    public JsonObject toJsonObject() {
        return new EasyJsonObject().add("playerName", this.playerName).add("playerDisplayName", this.playerDisplayName).add("prefix", this.prefix).add("suffix", this.suffix).add("playerID", this.nullString(this.playerID)).add("position", this.position).add("board", this.board).add("type", this.nullString((Object)this.type)).add("score", this.score).getHandle();
    }

    public static StatEntry fromJsonObject(LeaderboardPlugin plugin, JsonObject object) {
        return new StatEntry(object.get("position").getAsInt(), object.get("board").getAsString(), object.get("prefix").getAsString(), object.get("playerName").getAsString(), object.get("playerDisplayName").getAsString(), UUID.fromString(object.get("playerID").getAsString()), object.get("suffix").getAsString(), object.get("score").getAsDouble(), TimedType.valueOf(object.get("type").getAsString().toUpperCase(Locale.ROOT)));
    }

    public static void setPlugin(LeaderboardPlugin leaderboardPlugin) {
        plugin = leaderboardPlugin;
    }

    private String nullString(Object o) {
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    static {
        formatStringsSet = false;
        k = "k";
        m = "m";
        b = "b";
        t = "t";
        q = "q";
        qi = "qi";
        sx = "sx";
        sp = "sp";
        o = "o";
        n = "n";
        d = "d";
        ud = "ud";
    }
}

