/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.displays.lpcontext;

import net.luckperms.api.LuckPerms;
import net.luckperms.api.context.ContextCalculator;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;
import us.ajg0702.leaderboards.LeaderboardPlugin;
import us.ajg0702.leaderboards.displays.lpcontext.LuckpermsContextLoader;
import us.ajg0702.leaderboards.displays.lpcontext.PositionContext;

public class WithLPCtx
extends LuckpermsContextLoader {
    RegisteredServiceProvider<LuckPerms> provider = Bukkit.getServicesManager().getRegistration(LuckPerms.class);
    LuckPerms api = this.provider == null ? null : (LuckPerms)this.provider.getProvider();
    PositionContext context;

    public WithLPCtx(LeaderboardPlugin leaderboardPlugin) {
        super(leaderboardPlugin);
    }

    @Override
    public void load() {
        if (!Bukkit.getPluginManager().isPluginEnabled("LuckPerms")) {
            this.loaded = false;
            return;
        }
        if (this.provider == null || this.api == null) {
            this.plugin.getLogger().warning("LuckPerms is enabled on the server, but cannot load it's api provider! Position context cannot be registered!");
            this.loaded = false;
            return;
        }
        this.context = new PositionContext(this.plugin);
        this.api.getContextManager().registerCalculator((ContextCalculator)this.context);
        this.loaded = true;
        this.plugin.getLogger().info("LuckPerms position context calculator registered!");
    }

    @Override
    public void checkReload(boolean register) {
        if (this.loaded && !register && this.context != null) {
            this.api.getContextManager().unregisterCalculator((ContextCalculator)this.context);
            this.context = null;
        }
        if (!this.loaded && register) {
            this.load();
        }
        if (this.context != null) {
            this.context.reloadConfig();
        }
    }

    @Override
    public void calculatePotentialContexts() {
        if (!this.loaded || this.context == null) {
            return;
        }
        this.context.calculatePotentialContexts();
    }
}

