/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.formatting.formats;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import us.ajg0702.leaderboards.Debug;
import us.ajg0702.leaderboards.formatting.Format;

public class ColonTime
extends Format {
    private static final List<String> knownColonTimePlaceholders = Arrays.asList("parkour_player_personal_best_*_time");
    private final Pattern pattern = Pattern.compile("(([0-9]*):)?([0-9][0-9]?):([0-9][0-9]?)((:|\\.)([0-9][0-9]?[0-9]?))?$");
    DecimalFormat decimalFormat = new DecimalFormat("#,#00.###");

    private boolean isKnownTimePlaceholder(String placeholder) {
        boolean is = false;
        for (String knownTimePlaceholder : knownColonTimePlaceholders) {
            String[] parts;
            is = knownTimePlaceholder.contains("*") ? (knownTimePlaceholder.endsWith("*") ? placeholder.startsWith(knownTimePlaceholder.substring(0, knownTimePlaceholder.length() - 1)) : placeholder.startsWith((parts = knownTimePlaceholder.split("\\*"))[0]) && placeholder.endsWith(parts[1])) : placeholder.equals(knownTimePlaceholder);
            if (!is) continue;
            break;
        }
        return is;
    }

    @Override
    public boolean matches(String output, String placeholder) {
        if (this.isKnownTimePlaceholder(placeholder.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (output == null) {
            return false;
        }
        boolean matches = this.pattern.matcher(output).matches();
        Debug.info("[Format: ColonTime] '" + output + "' matches: " + matches);
        return matches;
    }

    @Override
    public double toDouble(String input) throws NumberFormatException {
        Matcher matcher = this.pattern.matcher(input);
        if (!matcher.matches()) {
            Debug.info("[Format: ColonTime] Matcher in toDouble does not match!");
            throw new NumberFormatException("For input: " + input);
        }
        int hours = Integer.parseInt(matcher.group(2) == null ? "0" : matcher.group(2));
        int minutes = Integer.parseInt(matcher.group(3));
        int seconds = Integer.parseInt(matcher.group(4));
        String secondSeparator = matcher.group(6);
        String milliseconds = matcher.group(7);
        double result = 0.0;
        result += (double)seconds;
        result += (double)(minutes * 60);
        result += (double)(hours * 60 * 60);
        if (secondSeparator != null && milliseconds != null) {
            if (secondSeparator.equals(":")) {
                result += (double)Integer.parseInt(milliseconds) / 1000.0;
            } else if (secondSeparator.equals(".")) {
                result += Double.parseDouble("0." + milliseconds);
            }
        }
        Debug.info(input + ": " + result);
        return result;
    }

    @Override
    public String toFormat(double input) {
        int hours = (int)(input / 3600.0);
        int minutes = (int)(input % 3600.0 / 60.0);
        double seconds = input % 60.0;
        return (hours == 0 ? "00" : this.addZero(hours)) + ":" + (minutes == 0 ? "00" : this.addZero(minutes)) + ":" + (seconds == 0.0 ? "00" : this.addZero(seconds));
    }

    @Override
    public String getName() {
        return "ColonTime";
    }

    private String addZero(int i) {
        if (i <= 9 && i >= 0) {
            return "0" + i;
        }
        return i + "";
    }

    private String addZero(double d) {
        return this.decimalFormat.format(d);
    }
}

