/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ajg0702.leaderboards.libs.jetbrains.annotations.Nullable;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.Component;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.TranslatableComponent;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.Context;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.ParsingException;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.tag.Tag;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import us.ajg0702.leaderboards.libs.kyori.adventure.text.minimessage.tag.standard.StandardTags;

final class TranslatableTag {
    private static final String TR = "tr";
    private static final String TRANSLATE = "translate";
    private static final String LANG = "lang";
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent(StandardTags.names("lang", "translate", "tr"), TranslatableTag::create, TranslatableTag::claim);

    private TranslatableTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        List with;
        String key = args.popOr("A translation key is required").value();
        if (args.hasNext()) {
            with = new ArrayList();
            while (args.hasNext()) {
                with.add(ctx.deserialize(args.pop().value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return Tag.inserting(Component.translatable(key, with));
    }

    @Nullable
    static Emitable claim(Component input) {
        if (!(input instanceof TranslatableComponent) || ((TranslatableComponent)input).fallback() != null) {
            return null;
        }
        TranslatableComponent tr = (TranslatableComponent)input;
        return emit -> {
            emit.tag(LANG);
            emit.argument(tr.key());
            for (Component with : tr.args()) {
                emit.argument(with);
            }
        };
    }
}

