/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.slimjar.relocation.facade;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import us.ajg0702.leaderboards.libs.slimjar.app.builder.ApplicationBuilder;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.InjectableClassLoader;
import us.ajg0702.leaderboards.libs.slimjar.injector.loader.IsolatedInjectableClassLoader;
import us.ajg0702.leaderboards.libs.slimjar.relocation.PassthroughRelocator;
import us.ajg0702.leaderboards.libs.slimjar.relocation.RelocationRule;
import us.ajg0702.leaderboards.libs.slimjar.relocation.facade.JarRelocatorFacade;
import us.ajg0702.leaderboards.libs.slimjar.relocation.facade.JarRelocatorFacadeFactory;
import us.ajg0702.leaderboards.libs.slimjar.relocation.facade.ReflectiveJarRelocatorFacade;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Dependency;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.DependencyData;
import us.ajg0702.leaderboards.libs.slimjar.resolver.data.Repository;
import us.ajg0702.leaderboards.libs.slimjar.util.Packages;

public final class ReflectiveJarRelocatorFacadeFactory
implements JarRelocatorFacadeFactory {
    private static final String JAR_RELOCATOR_PACKAGE = "me#lucko#jarrelocator#JarRelocator";
    private static final String RELOCATION_PACKAGE = "me#lucko#jarrelocator#Relocation";
    private final Constructor<?> jarRelocatorConstructor;
    private final Constructor<?> relocationConstructor;
    private final Method jarRelocatorRunMethod;

    private ReflectiveJarRelocatorFacadeFactory(Constructor<?> jarRelocatorConstructor, Constructor<?> relocationConstructor, Method jarRelocatorRunMethod) {
        this.jarRelocatorConstructor = jarRelocatorConstructor;
        this.relocationConstructor = relocationConstructor;
        this.jarRelocatorRunMethod = jarRelocatorRunMethod;
    }

    @Override
    public JarRelocatorFacade createFacade(File input, File output, Collection<RelocationRule> relocationRules) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        HashSet<Object> relocations = new HashSet<Object>();
        for (RelocationRule rule : relocationRules) {
            relocations.add(ReflectiveJarRelocatorFacadeFactory.createRelocation(this.relocationConstructor, rule));
        }
        Object relocator = ReflectiveJarRelocatorFacadeFactory.createRelocator(this.jarRelocatorConstructor, input, output, relocations);
        return new ReflectiveJarRelocatorFacade(relocator, this.jarRelocatorRunMethod);
    }

    private static Object createRelocation(Constructor<?> relocationConstructor, RelocationRule rule) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return relocationConstructor.newInstance(rule.getOriginalPackagePattern(), rule.getRelocatedPackagePattern(), rule.getExclusions(), rule.getInclusions());
    }

    private static Object createRelocator(Constructor<?> jarRelocatorConstructor, File input, File output, Collection<Object> rules) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        return jarRelocatorConstructor.newInstance(input, output, rules);
    }

    private static DependencyData getJarRelocatorDependency(Collection<Repository> repositories) throws MalformedURLException {
        Dependency asm = new Dependency(Packages.fix("org#ow2#asm"), "asm", "9.1", null, Collections.emptyList());
        Dependency asmCommons = new Dependency(Packages.fix("org#ow2#asm"), "asm-commons", "9.1", null, Collections.emptyList());
        Dependency jarRelocator = new Dependency(Packages.fix("me#lucko"), "jar-relocator", "1.4", null, Arrays.asList(asm, asmCommons));
        return new DependencyData(Collections.emptySet(), repositories, Collections.singleton(jarRelocator), Collections.emptyList());
    }

    public static JarRelocatorFacadeFactory create(Path downloadPath, Collection<Repository> repositories) throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        IsolatedInjectableClassLoader classLoader = new IsolatedInjectableClassLoader();
        return ReflectiveJarRelocatorFacadeFactory.create(downloadPath, repositories, classLoader);
    }

    public static JarRelocatorFacadeFactory create(Path downloadPath, Collection<Repository> repositories, InjectableClassLoader classLoader) throws URISyntaxException, ReflectiveOperationException, NoSuchAlgorithmException, IOException {
        ApplicationBuilder.injecting("SlimJar", classLoader).downloadDirectoryPath(downloadPath).preResolutionDataProviderFactory(a -> Collections::emptyMap).dataProviderFactory(url -> () -> ReflectiveJarRelocatorFacadeFactory.getJarRelocatorDependency(repositories)).relocatorFactory(rules -> new PassthroughRelocator()).relocationHelperFactory(relocator -> (dependency, file) -> file).build();
        Class<?> jarRelocatorClass = Class.forName(Packages.fix(JAR_RELOCATOR_PACKAGE), true, classLoader);
        Class<?> relocationClass = Class.forName(Packages.fix(RELOCATION_PACKAGE), true, classLoader);
        Constructor<?> jarRelocatorConstructor = jarRelocatorClass.getConstructor(File.class, File.class, Collection.class);
        Constructor<?> relocationConstructor = relocationClass.getConstructor(String.class, String.class, Collection.class, Collection.class);
        Method runMethod = jarRelocatorClass.getMethod("run", new Class[0]);
        return new ReflectiveJarRelocatorFacadeFactory(jarRelocatorConstructor, relocationConstructor, runMethod);
    }
}

