/*
 * Decompiled with CFR 0.152.
 */
package us.ajg0702.leaderboards.libs.utils.foliacompat;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitWorker;
import us.ajg0702.leaderboards.libs.utils.foliacompat.Task;
import us.ajg0702.leaderboards.libs.utils.foliacompat.tasks.BukkitTask;
import us.ajg0702.leaderboards.libs.utils.foliacompat.tasks.FoliaAsyncTask;

public class CompatScheduler {
    public final Plugin plugin;
    private static Boolean isFolia;

    public CompatScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    public void runSync(Location location, Runnable task) {
        if (CompatScheduler.isFolia()) {
            Object regionScheduler = CompatScheduler.getRegionScheduler();
            try {
                regionScheduler.getClass().getMethod("execute", Plugin.class, Location.class, Runnable.class).invoke(regionScheduler, this.plugin, location, task);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            Bukkit.getScheduler().runTask(this.plugin, task);
        }
    }

    public void runSync(Entity entity, Runnable task) {
        if (CompatScheduler.isFolia()) {
            try {
                Object entityScheduler = entity.getClass().getMethod("getScheduler", new Class[0]).invoke((Object)entity, new Object[0]);
                entityScheduler.getClass().getMethod("run", Plugin.class, Consumer.class, Runnable.class).invoke(entityScheduler, this.plugin, a -> task.run(), null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            Bukkit.getScheduler().runTask(this.plugin, task);
        }
    }

    public void runTaskAsynchronously(Runnable task) {
        if (CompatScheduler.isFolia()) {
            Object asyncScheduler = CompatScheduler.getAsyncScheduler();
            try {
                asyncScheduler.getClass().getMethod("runNow", Plugin.class, Consumer.class).invoke(asyncScheduler, this.plugin, a -> task.run());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            Bukkit.getScheduler().runTaskAsynchronously(this.plugin, task);
        }
    }

    public Task runTaskLaterAsynchronously(Runnable task, long delay) {
        if (CompatScheduler.isFolia()) {
            Object asyncScheduler = CompatScheduler.getAsyncScheduler();
            try {
                return new FoliaAsyncTask(asyncScheduler.getClass().getMethod("runDelayed", Plugin.class, Consumer.class, Long.TYPE, TimeUnit.class).invoke(asyncScheduler, new Object[]{this.plugin, a -> task.run(), delay * 50L, TimeUnit.MILLISECONDS}));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return new BukkitTask(Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, task, delay));
    }

    public List<BukkitWorker> getActiveWorkers() {
        if (CompatScheduler.isFolia()) {
            return Collections.emptyList();
        }
        return Bukkit.getScheduler().getActiveWorkers();
    }

    public Task runTaskTimerAsynchronously(Runnable task, long delay, long period) {
        if (CompatScheduler.isFolia()) {
            Object asyncScheduler = CompatScheduler.getAsyncScheduler();
            try {
                return new FoliaAsyncTask(asyncScheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE, TimeUnit.class).invoke(asyncScheduler, new Object[]{this.plugin, a -> task.run(), delay * 50L, period * 50L, TimeUnit.MILLISECONDS}));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.plugin.getLogger().warning(Arrays.toString(asyncScheduler.getClass().getMethods()));
                throw new RuntimeException(e);
            }
        }
        return new BukkitTask(Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, task, delay, period));
    }

    public void cancelTasks() {
        if (CompatScheduler.isFolia()) {
            Object asyncScheduler = CompatScheduler.getAsyncScheduler();
            try {
                asyncScheduler.getClass().getMethod("cancelTasks", Plugin.class).invoke(asyncScheduler, this.plugin);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            Bukkit.getScheduler().cancelTasks(this.plugin);
        }
    }

    public static Object getRegionScheduler() {
        if (!CompatScheduler.isFolia()) {
            throw new IllegalStateException("Cannot get region scheduler from non-folia!");
        }
        try {
            return Bukkit.class.getDeclaredMethod("getRegionScheduler", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getAsyncScheduler() {
        if (!CompatScheduler.isFolia()) {
            throw new IllegalStateException("Cannot get region scheduler from non-folia!");
        }
        try {
            return Bukkit.class.getDeclaredMethod("getAsyncScheduler", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isFolia() {
        if (isFolia == null) {
            try {
                Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
                isFolia = true;
            }
            catch (ClassNotFoundException e) {
                isFolia = false;
            }
        }
        return isFolia;
    }
}

